/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.management.AddressSettingsInfo;
import org.hornetq.api.core.management.RoleInfo;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.jboss.as.integration.hornetq.management.jms.AddressSettingsMapper;
import org.jboss.as.integration.hornetq.management.jms.JMSManageMO;
import org.jboss.as.integration.hornetq.management.jms.MessageListMapper;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.metatype.api.annotations.MetaMapping;

@ManagementObject(componentType=@ManagementComponent(type="JMSDestinationManage", subtype="QueueManage"), properties=ManagementProperties.EXPLICIT, isRuntime=true)
public class QueueManageMO
extends JMSManageMO {
    public QueueManageMO(HornetQServer server) {
        super(server);
    }

    @ManagementOperation(name="createQueue", description="Creates a new Queue", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="jndiName", description="The JNDI Name of the queue"), @ManagementParameter(name="dla", description="Dead Letter Address"), @ManagementParameter(name="expiryAddress", description="Expiry Address"), @ManagementParameter(name="maxSizeBytes", description="Max Size of Address"), @ManagementParameter(name="pageSizeBytes", description="Page Size"), @ManagementParameter(name="deliveryAttempts", description="Max Delivery Attempts"), @ManagementParameter(name="redeliveryDelay", description="Redelivery Delay"), @ManagementParameter(name="lastValueQueue", description="Last Value Queue"), @ManagementParameter(name="redistributionDelay", description="Redistribution Delay"), @ManagementParameter(name="sendToDLAOnNoRoute", description="Send To DLA on no route"), @ManagementParameter(name="addressFullMessagePolicy", description="Address Full Message Policy"), @ManagementParameter(name="sendRoles", description="Send roles for a queue"), @ManagementParameter(name="consumeRoles", description="consume roles for a queue")})
    public void createQueue(String name, String jndiName, String DLA, String expiryAddress, long maxSizeBytes, int pageSizeBytes, int deliveryAttempts, long redeliveryDelay, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, String sendRoles, String consumeRoles) throws Exception {
        this.hornetQServerControl.addAddressSettings("jms.queue." + name, DLA, expiryAddress, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, redeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy);
        this.jmsServerControl.createQueue(name, jndiName);
        this.hornetQServerControl.addSecuritySettings("jms.queue." + name, sendRoles, consumeRoles, "", "", "", "", "");
    }

    @ManagementOperation(name="deleteQueue", description="delete the queue", params={@ManagementParameter(name="name", description="the queue name")})
    public void deleteQueue(String name) throws Exception {
        this.jmsServerControl.destroyQueue(name.replace("jms.queue.", ""));
        this.hornetQServerControl.removeSecuritySettings(name);
        this.hornetQServerControl.removeAddressSettings(name);
    }

    @ManagementOperation(name="getQueueConfiguration", description="Returns a queues configuration", params={@ManagementParameter(name="name", description="the queue name")})
    @MetaMapping(value=AddressSettingsMapper.class)
    public Object[] getQueueConfiguration(String name) throws Exception {
        RoleInfo[] roles;
        Object[] config = new Object[3];
        JMSQueueControl control = (JMSQueueControl)this.managementService.getResource(name);
        JMSQueueConfigurationImpl queueConfiguration = new JMSQueueConfigurationImpl(control.getName(), control.getSelector(), !control.isTemporary(), control.getJNDIBindings());
        config[0] = queueConfiguration;
        String addressSettingsAsJSON = this.hornetQServerControl.getAddressSettingsAsJSON(name);
        config[1] = AddressSettingsInfo.from((String)addressSettingsAsJSON);
        String rolesAsJSON = this.hornetQServerControl.getRolesAsJSON(name);
        config[2] = roles = RoleInfo.from((String)rolesAsJSON);
        return config;
    }

    @ManagementOperation(name="updateQueueConfiguration", description="updates a queues configuration", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="jndiName", description="The JNDI Name of the queue"), @ManagementParameter(name="dla", description="Dead Letter Address"), @ManagementParameter(name="expiryAddress", description="Expiry Address"), @ManagementParameter(name="maxSizeBytes", description="Max Size of Address"), @ManagementParameter(name="pageSizeBytes", description="Page Size"), @ManagementParameter(name="deliveryAttempts", description="Max Delivery Attempts"), @ManagementParameter(name="redeliveryDelay", description="Redelivery Delay"), @ManagementParameter(name="lastValueQueue", description="Last Value Queue"), @ManagementParameter(name="redistributionDelay", description="Redistribution Delay"), @ManagementParameter(name="sendToDLAOnNoRoute", description="Send To DLA on no route"), @ManagementParameter(name="addressFullMessagePolicy", description="Address Full Message Policy"), @ManagementParameter(name="sendRoles", description="Send roles for a queue"), @ManagementParameter(name="consumeRoles", description="consume roles for a queue")})
    public void updateQueueConfiguration(String name, String jndiName, String dla, String expiryAddress, long maxSizeBytes, int pageSizeBytes, int deliveryAttempts, long redeliveryDelay, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, String sendRoles, String consumeRoles) throws Exception {
        this.hornetQServerControl.addAddressSettings(name, dla, expiryAddress, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, redeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy);
        this.hornetQServerControl.addSecuritySettings(name, sendRoles, consumeRoles, "", "", "", "", "");
    }

    @ManagementOperation(name="getQueueMeasurements", description="updates a queues configuration", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="names", description="the measurement names")})
    public String[] getQueueMeasurements(String name, String[] names) throws Exception {
        JMSQueueControl control = (JMSQueueControl)this.managementService.getResource(name);
        String[] val = new String[names.length];
        int valLength = val.length;
        for (int i = 0; i < valLength; ++i) {
            Object o = control.getClass().getMethod(names[i], new Class[0]).invoke((Object)control, new Object[0]);
            val[i] = o instanceof Object[] ? this.coomaSeparatedString((Object[])o) : o.toString();
        }
        return val;
    }

    @ManagementOperation(name="invokeQueueOperation", description="invokes a queues method", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="method", description="the method"), @ManagementParameter(name="params", description="the method params")})
    public Object invokeQueueOperation(String name, String method, String[] params, String[] type) throws Exception {
        JMSQueueControl control = (JMSQueueControl)this.managementService.getResource(name);
        Class[] classes = this.getClassTypes(type);
        Method m = control.getClass().getMethod(method, classes);
        return m.invoke((Object)control, this.getParams(params, classes));
    }

    @ManagementOperation(name="invokeQueueOperationMessageType", description="invokes a queues method", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="method", description="the method"), @ManagementParameter(name="params", description="the method params")})
    @MetaMapping(value=MessageListMapper.class)
    public List invokeQueueOperationMessageType(String name, String method, String[] params, String[] type) throws Exception {
        JMSQueueControl control = (JMSQueueControl)this.managementService.getResource(name);
        Class[] classes = this.getClassTypes(type);
        Method m = control.getClass().getMethod(method, classes);
        Map[] maps = (Map[])m.invoke((Object)control, this.getParams(params, classes));
        ArrayList<Map> list = new ArrayList<Map>();
        list.addAll(Arrays.asList(maps));
        return list;
    }

    @ManagementOperation(name="getJMSQueues", description="returns the JMS Queues")
    public String[] getJMSQueues() {
        return this.jmsServerControl.getQueueNames();
    }

    @ManagementOperation(name="isPaused", description="is the queue paused?", params={@ManagementParameter(name="name", description="the queue name")})
    public boolean isPaused(String name) throws Exception {
        JMSQueueControl control = (JMSQueueControl)this.managementService.getResource(name);
        return control.isPaused();
    }
}

