/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListMapper
extends MetaMapper<List> {
    private static final Logger log = Logger.getLogger(MessageListMapper.class);
    public static final CollectionMetaType TYPE;
    public static final CompositeMetaType MSG_TYPE;

    public MetaValue createMetaValue(MetaType metaType, List object) {
        ArrayList<CompositeValueSupport> tmp = new ArrayList<CompositeValueSupport>();
        if (object != null) {
            for (Object o : object) {
                Map m = (Map)o;
                try {
                    CompositeValueSupport cvs = new CompositeValueSupport(MSG_TYPE);
                    cvs.set("JMSMessageID", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)m.get("JMSMessageID").toString())));
                    cvs.set("JMSTimestamp", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)m.get("JMSTimestamp").toString())));
                    cvs.set("JMSPriority", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)m.get("JMSPriority").toString())));
                    cvs.set("JMSDeliveryMode", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)m.get("JMSDeliveryMode").toString())));
                    cvs.set("JMSExpiration", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)m.get("JMSExpiration").toString())));
                    tmp.add(cvs);
                }
                catch (Exception e) {
                    log.warn((Object)("Skipping msg: " + m), (Throwable)e);
                }
            }
        }
        MetaValue[] elements = new MetaValue[tmp.size()];
        tmp.toArray(elements);
        CollectionValueSupport msgs = new CollectionValueSupport(TYPE, elements);
        return msgs;
    }

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return List.class;
    }

    public List unwrapMetaValue(MetaValue metaValue) {
        return null;
    }

    static {
        String[] itemNames = new String[]{"JMSMessageID", "JMSTimestamp", "JMSPriority", "JMSDeliveryMode", "JMSExpiration"};
        String[] itemDescriptions = new String[]{"JMSMessageID", "JMSTimestamp", "JMSPriority", "JMSDeliveryMode", "JMSExpiration"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING};
        MSG_TYPE = new ImmutableCompositeMetaType("javax.jms.Message", "JMS Message", itemNames, itemDescriptions, itemTypes);
        TYPE = new CollectionMetaType("java.util.List", (MetaType)MSG_TYPE);
    }
}

