/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.varia.deployment.BeanShellScript;
import org.jboss.varia.deployment.BeanShellScriptClient;

@ManagementObject
public class LegacyBeanShellScriptClient
implements BeanShellScriptClient {
    protected Logger log = Logger.getLogger(this.getClass());
    private DeployerClient deployer;

    public LegacyBeanShellScriptClient(DeployerClient deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null client deployer.");
        }
        this.deployer = deployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanShellScript createBeanShellScript(String bshScript, String scriptName) throws org.jboss.deployment.DeploymentException {
        ByteArrayInputStream stream = new ByteArrayInputStream(bshScript.getBytes());
        try {
            BeanShellScript beanShellScript = new BeanShellScript(this + ": " + scriptName, stream);
            return beanShellScript;
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException ignored) {}
        }
    }

    @ManagementOperation
    public String createScriptDeployment(String bshScript, String scriptName) throws DeploymentException {
        if (bshScript == null) {
            throw new IllegalArgumentException("Null bean shell script.");
        }
        if (scriptName == null) {
            throw new IllegalArgumentException("Null script name.");
        }
        BeanShellScript script = this.createBeanShellScript(bshScript, scriptName);
        AbstractDeployment deployment = new AbstractDeployment(scriptName);
        MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        mutableAttachments.addAttachment(BeanShellScript.class, (Object)script);
        this.deployer.addDeployment((Deployment)deployment);
        this.deployer.process();
        return deployment.getName();
    }

    @ManagementOperation
    public void removeScriptDeployment(String scriptName) throws DeploymentException {
        this.deployer.removeDeployment(scriptName);
    }
}

