/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.remoting.InvokerLocator;

public class ClusteredPojiProxy
implements Serializable,
InvocationHandler {
    private static final long serialVersionUID = 8054816523858555978L;
    private Object oid;
    private InvokerLocator uri;
    private Interceptor[] interceptors;
    private FamilyWrapper family;
    private LoadBalancePolicy lbPolicy;
    private String partitionName;
    private Object originTarget;

    public ClusteredPojiProxy(Object oid, InvokerLocator uri, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lb, String partitionName, Object originTarget) {
        this.oid = oid;
        this.uri = uri;
        this.interceptors = interceptors;
        this.family = family;
        this.lbPolicy = lb;
        this.partitionName = partitionName;
        this.originTarget = originTarget;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
        sri.setArguments(args);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER", (Object)this.family, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY", (Object)this.lbPolicy, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"PARTITION_NAME", (Object)this.partitionName, PayloadKey.TRANSIENT);
        if (this.originTarget != null) {
            sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"HA_TARGET", this.originTarget, PayloadKey.TRANSIENT);
        }
        sri.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", this.oid, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)this.uri, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        return sri.invokeNext();
    }
}

