/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.inject.naming;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javassist.Modifier;
import javax.naming.Context;
import org.jboss.injection.inject.Injector;
import org.jboss.injection.inject.naming.ContextValueRetriever;
import org.jboss.injection.inject.pojo.FieldInjectionPoint;
import org.jboss.injection.inject.pojo.MethodInjectionPoint;
import org.jboss.injection.inject.spi.InjectionPoint;
import org.jboss.injection.resolve.spi.EnvironmentMetaDataVisitor;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionProcessor {
    private List<EnvironmentMetaDataVisitor<ResourceInjectionMetaData>> visitors;

    public InjectionProcessor() {
        this(new ArrayList<EnvironmentMetaDataVisitor<ResourceInjectionMetaData>>());
    }

    public InjectionProcessor(List<EnvironmentMetaDataVisitor<ResourceInjectionMetaData>> visitors) {
        this.visitors = visitors;
    }

    public List<Injector<Object>> process(Context enc, ClassLoader cl, Environment environment) throws Exception {
        ArrayList<Injector<Object>> injectors = new ArrayList<Injector<Object>>();
        for (EnvironmentMetaDataVisitor<ResourceInjectionMetaData> visitor : this.visitors) {
            injectors.addAll(this.process(enc, cl, visitor.getMetaData(environment)));
        }
        return injectors;
    }

    private <M extends Iterable<T>, T extends ResourceInjectionMetaData> List<Injector<Object>> process(Context enc, ClassLoader cl, M injections) throws Exception {
        ArrayList<Injector<Object>> injectors = new ArrayList<Injector<Object>>();
        if (injections == null) {
            return injectors;
        }
        for (ResourceInjectionMetaData injection : injections) {
            String encName = injection.getName();
            ContextValueRetriever encValRetriever = new ContextValueRetriever(enc, encName);
            Set injectionTargets = injection.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.isEmpty()) continue;
            for (ResourceInjectionTargetMetaData injectionTarget : injectionTargets) {
                Class<?> targetClass = cl.loadClass(injectionTarget.getInjectionTargetClass());
                String targetName = injectionTarget.getInjectionTargetName();
                InjectionPoint<Object, Object> injectionPoint = this.getInjectionPoint(targetClass, targetName);
                Injector<Object> injector = new Injector<Object>(injectionPoint, encValRetriever);
                injectors.add(injector);
            }
        }
        return injectors;
    }

    private InjectionPoint<Object, Object> getInjectionPoint(Class<?> injectionTargetClass, String injectionTargetName) {
        Method[] methods;
        String methodName = "set" + injectionTargetName;
        for (Method m : methods = injectionTargetClass.getDeclaredMethods()) {
            if (Modifier.isPrivate((int)m.getModifiers()) || m.getParameterTypes().length != 1 || !m.getName().equals(methodName)) continue;
            return new MethodInjectionPoint<Object, Object>(m);
        }
        try {
            Field field = injectionTargetClass.getDeclaredField(injectionTargetName);
            return new FieldInjectionPoint<Object, Object>(field);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Injection target not found on class " + injectionTargetClass + " and target name " + injectionTargetName);
        }
    }
}

