/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.inject;

import org.jboss.injection.inject.spi.InjectionPoint;
import org.jboss.injection.inject.spi.ValueRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Injector<T> {
    private final TypedDelegate<T, ?> delegate;

    public <V> Injector(InjectionPoint<T, V> injectionPoint, ValueRetriever<V> valueRetriever) {
        if (injectionPoint == null) {
            throw new IllegalArgumentException("TypedDelegate point can not be null");
        }
        if (valueRetriever == null) {
            throw new IllegalArgumentException("Value retriever can not be null");
        }
        this.delegate = new TypedDelegate(injectionPoint, valueRetriever);
    }

    public void inject(T target) {
        ((TypedDelegate)this.delegate).injectInto(target);
    }

    public String toString() {
        return "Injector{injectionPoint=" + ((TypedDelegate)this.delegate).injectionPoint + ", valueRetriever=" + ((TypedDelegate)this.delegate).valueRetriever + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypedDelegate<T, V> {
        private final ValueRetriever<V> valueRetriever;
        private final InjectionPoint<T, V> injectionPoint;

        private TypedDelegate(InjectionPoint<T, V> injectionPoint, ValueRetriever<V> valueRetriever) {
            this.injectionPoint = injectionPoint;
            this.valueRetriever = valueRetriever;
        }

        private void injectInto(T target) {
            V value = this.getValue();
            this.injectionPoint.set(target, value);
        }

        protected V getValue() {
            return this.valueRetriever.getValue();
        }
    }
}

