/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.seam.Seam;
import org.jboss.seam.security.Identity;

class IdentityRequestWrapper
extends HttpServletRequestWrapper {
    private Identity identity;

    public IdentityRequestWrapper(HttpServletRequest request) {
        super(request);
        this.identity = (Identity)request.getSession().getAttribute(Seam.getComponentName(Identity.class));
    }

    public String getRemoteUser() {
        return this.getUserPrincipal() != null ? this.getUserPrincipal().getName() : null;
    }

    public Principal getUserPrincipal() {
        return Identity.isSecurityEnabled() && this.identity != null ? this.identity.getPrincipal() : null;
    }

    public boolean isUserInRole(String role) {
        return this.getUserPrincipal() != null && this.identity != null ? this.identity.hasRole(role) : false;
    }
}

