/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values.mappers;

import java.io.Serializable;
import java.lang.reflect.Type;
import javax.management.ObjectName;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringObjectNameMetaMapper
extends MetaMapper<ObjectName> {
    @Override
    public MetaType getMetaType() {
        return SimpleMetaType.STRING;
    }

    @Override
    public Type mapToType() {
        return ObjectName.class;
    }

    @Override
    public MetaValue createMetaValue(MetaType metaType, ObjectName object) {
        String str = object.getCanonicalName();
        return SimpleValueSupport.wrap((Serializable)((Object)str));
    }

    @Override
    public ObjectName unwrapMetaValue(MetaValue metaValue) {
        SimpleValue sv = (SimpleValue)metaValue;
        String str = sv.getValue().toString();
        try {
            return new ObjectName(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

