/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.core.deployable;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.embedded.api.Deployable;

public final class DeployableUrl
implements Deployable {
    private final URL url;

    public DeployableUrl(URL url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("url must be specified");
        }
        this.url = DeployableUrl.copyURL(url);
    }

    public URL getTarget() {
        return DeployableUrl.copyURL(this.url);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        try {
            result = 31 * result + (this.url == null ? 0 : this.url.toURI().hashCode());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeployableUrl other = (DeployableUrl)obj;
        if (this.url == null) {
            if (other.url != null) {
                return false;
            }
        } else {
            try {
                if (!this.url.toURI().equals(other.url.toURI())) {
                    return false;
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [url=" + this.url.toExternalForm() + "]";
    }

    private static URL copyURL(URL url) {
        if (url == null) {
            return url;
        }
        try {
            return new URL(url.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in copying URL", e);
        }
    }
}

