/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class ClientGIOPConnection
extends GIOPConnection
implements Configurable {
    private boolean ignore_pending_messages_on_timeout = false;

    public ClientGIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener, StatisticsProvider statisticsProvider) {
        super(profile, connection, requestListener, replyListener, statisticsProvider);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.ignore_pending_messages_on_timeout = configuration.getAttribute("jacorb.connection.client.timeout_ignores_pending_messages", "off").equals("on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTimedOut() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": readTimedOut()");
        }
        Object object = this.pendingUndecidedSync;
        synchronized (object) {
            if (this.ignore_pending_messages_on_timeout) {
                this.streamClosed();
            } else if (!this.hasPendingMessages()) {
                this.closeAllowReopen();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": cannot close because there are pending messages");
            }
        }
    }

    protected void streamClosed() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": streamClosed()");
        }
        this.closeAllowReopen();
        if (this.connection_listener != null) {
            this.connection_listener.streamClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllowReopen() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": closeAllowReopen()");
        }
        try {
            Object object = this.connect_sync;
            synchronized (object) {
                this.getWriteLock();
                this.transport.close();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public String toString() {
        return "ClientGIOPConnection to " + this.profile.toString() + " (" + Integer.toHexString(this.hashCode()) + ")";
    }
}

