/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsf.deployer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jsf.deployer.JSFImplMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.SuffixMatchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFImplManagementDeployer
extends AbstractSimpleVFSRealDeployer<WebMetaData> {
    private static final String JSF_CONFIG_PARAM = "org.jboss.jbossfaces.JSF_CONFIG_NAME";
    private static final String JSF_CONFIG_FILES_PARAM = "javax.faces.CONFIG_FILES";
    private static final String WAR_BUNDLES_JSF_PARAM = "org.jboss.jbossfaces.WAR_BUNDLES_JSF_IMPL";
    private static final VirtualFileFilter JAR_FILTER = new SuffixMatchFilter(".jar");
    private static final VirtualFileFilter FACES_CONFIG_FILTER = new SuffixMatchFilter(".faces-config.xml");
    private Collection<String> facesServlets;
    private String defaultJSFConfiguration;
    private Map<String, URL> jsfConfigurations;
    private boolean jsfDisabled = false;
    private boolean alwaysAddJSF = false;
    private Map<String, JSFImplMetaData> jsfImplMetatData = new HashMap<String, JSFImplMetaData>();

    public JSFImplManagementDeployer() {
        super(WebMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setOutput(JSFImplMetaData.class);
    }

    public void start() throws DeploymentException {
        this.createJSFImplMetaData();
    }

    protected void createJSFImplMetaData() throws DeploymentException {
        if (this.jsfConfigurations == null) {
            this.log.warn((Object)"No JSF implementations specified in jsf-integration-deployer-jboss-beans.xml. Integrated JSF is disabled.");
            this.jsfDisabled = true;
            return;
        }
        for (Map.Entry<String, URL> implEntry : this.jsfConfigurations.entrySet()) {
            try {
                this.jsfImplMetatData.put(implEntry.getKey(), new JSFImplMetaData(implEntry.getKey(), implEntry.getValue()));
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Malformed URL", (Throwable)e);
            }
        }
        this.log.info((Object)("Initialized " + this.jsfImplMetatData.size() + " JSF configurations: " + this.jsfImplMetatData.keySet()));
    }

    public void setAlwaysAddJSF(boolean alwaysAddJSF) {
        this.alwaysAddJSF = alwaysAddJSF;
    }

    public void setFacesServlets(Collection<String> facesServlets) {
        this.facesServlets = Collections.unmodifiableCollection(facesServlets);
    }

    public void setDefaultJSFConfig(String defaultJSFConfig) {
        this.defaultJSFConfiguration = defaultJSFConfig;
    }

    public void setJsfConfigurations(Map<String, String> jsfConfigs) throws MalformedURLException {
        this.jsfConfigurations = new HashMap<String, URL>(jsfConfigs.size());
        for (Map.Entry<String, String> configEntry : jsfConfigs.entrySet()) {
            String strURL = StringPropertyReplacer.replaceProperties((String)configEntry.getValue());
            this.jsfConfigurations.put(configEntry.getKey(), new URL(strURL));
        }
    }

    public JSFImplMetaData getJSFImpl(String configName) {
        return this.jsfImplMetatData.get(configName);
    }

    private boolean isJSFDeployment(VFSDeploymentUnit unit, WebMetaData metaData) throws DeploymentException {
        return this.alwaysAddJSF || this.getContextParam(JSF_CONFIG_PARAM, metaData) != null || this.getContextParam(JSF_CONFIG_FILES_PARAM, metaData) != null || unit.getFile("WEB-INF/faces-config.xml") != null || this.isJSFServletInWebInfWebXml(metaData.getServlets()) || this.isJSFServletInWebFragment(unit) || this.isFacesConfigInWebInfLibJar(unit);
    }

    private boolean isFacesConfigInWebInfLibJar(VFSDeploymentUnit unit) throws DeploymentException {
        VirtualFile webInfLib = unit.getFile("WEB-INF/lib");
        if (webInfLib == null) {
            return false;
        }
        try {
            for (VirtualFile jarFile : webInfLib.getChildren(JAR_FILTER)) {
                VirtualFile metaInf = jarFile.getChild("META-INF");
                if (!metaInf.exists()) {
                    return false;
                }
                VirtualFile facesConfig = metaInf.getChild("faces-config.xml");
                if (facesConfig.exists()) {
                    return true;
                }
                if (metaInf.getChildren(FACES_CONFIG_FILTER).isEmpty()) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Unable to search WEB-INF/lib for faces-config files", (Throwable)e);
        }
        return false;
    }

    private boolean isJSFServletInWebInfWebXml(ServletsMetaData servlets) {
        if (servlets == null) {
            return false;
        }
        for (ServletMetaData servletMetaData : servlets) {
            String servletClass = servletMetaData.getServletClass();
            if (!this.facesServlets.contains(servletClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isJSFServletInWebFragment(VFSDeploymentUnit unit) {
        String fragmentName = WebFragmentMetaData.class.getName();
        Map attachments = unit.getAttachments();
        for (Map.Entry entry : attachments.entrySet()) {
            WebFragmentMetaData fragment = null;
            if (!((String)entry.getKey()).startsWith(fragmentName) || !this.isJSFServletInWebInfWebXml((fragment = (WebFragmentMetaData)entry.getValue()).getServlets())) continue;
            return true;
        }
        return false;
    }

    private String getContextParam(String paramName, WebMetaData metaData) {
        List contextParams = metaData.getContextParams();
        if (contextParams == null) {
            return null;
        }
        for (ParamValueMetaData param : contextParams) {
            if (!param.getParamName().equals(paramName)) continue;
            return param.getParamValue();
        }
        return null;
    }

    private boolean isWarBundlesJSF(WebMetaData metaData) {
        String warBundlesJSF = this.getContextParam(WAR_BUNDLES_JSF_PARAM, metaData);
        return warBundlesJSF != null && warBundlesJSF.equalsIgnoreCase("true");
    }

    public void deploy(VFSDeploymentUnit unit, WebMetaData metaData) throws DeploymentException {
        if (this.jsfDisabled || !this.isJSFDeployment(unit, metaData) || this.isWarBundlesJSF(metaData)) {
            return;
        }
        JSFImplMetaData jsfImpl = this.findWhichJSFImplToUse(metaData);
        unit.addAttachment(JSFImplMetaData.class, (Object)jsfImpl);
    }

    private JSFImplMetaData findWhichJSFImplToUse(WebMetaData metaData) {
        String implToUse = this.getContextParam(JSF_CONFIG_PARAM, metaData);
        if (implToUse != null) {
            return this.jsfImplMetatData.get(implToUse);
        }
        return this.jsfImplMetatData.get(this.defaultJSFConfiguration);
    }
}

