/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.jboss.aop.util.MarshalledValueInputStream;
import org.jboss.aop.util.MarshalledValueOutputStream;

public class MarshalledValue
implements Externalizable {
    private static final long serialVersionUID = -1527598981234110311L;
    private byte[] serializedForm = null;
    private int hashCode;
    private boolean isHashComputed = false;
    private ByteArrayOutputStream baos = null;

    public MarshalledValue() {
    }

    public MarshalledValue(Object obj) throws IOException {
        this.baos = new ByteArrayOutputStream();
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream(this.baos);
        mvos.writeObject(obj);
        mvos.flush();
        this.serializedForm = this.baos.toByteArray();
        this.isHashComputed = false;
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.serializedForm == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.serializedForm);
        MarshalledValueInputStream mvis = new MarshalledValueInputStream(bais);
        return mvis.readObject();
    }

    public byte[] toByteArray() {
        return this.serializedForm;
    }

    public int size() {
        int size = this.serializedForm != null ? this.serializedForm.length : 0;
        return size;
    }

    public int hashCode() {
        if (!this.isHashComputed) {
            int hash = 0;
            for (int i = 0; i < this.serializedForm.length; ++i) {
                hash = 31 * hash + this.serializedForm[i];
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean equals = false;
        if (obj instanceof MarshalledValue) {
            MarshalledValue mv = (MarshalledValue)obj;
            equals = this.serializedForm == mv.serializedForm ? true : Arrays.equals(this.serializedForm, mv.serializedForm);
        }
        return equals;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.serializedForm = null;
        if (length > 0) {
            this.serializedForm = new byte[length];
            in.readFully(this.serializedForm);
        }
        this.isHashComputed = false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.baos.size());
        out.write(this.baos.toByteArray());
    }
}

