/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.autonumber;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.varia.autonumber.AutoNumber;
import org.jboss.varia.autonumber.AutoNumberHome;

public class AutoNumberFactory {
    private static final Logger log = Logger.getLogger(AutoNumberFactory.class);
    private static AutoNumberHome autoNumberHome;

    public static synchronized Integer getNextInteger(String collectionName) throws ArrayIndexOutOfBoundsException {
        Integer value = null;
        AutoNumber autoNumber = null;
        if (autoNumberHome == null) {
            try {
                autoNumberHome = (AutoNumberHome)new InitialContext().lookup("JBossUtilAutoNumber");
            }
            catch (NamingException e) {
                log.error((Object)"operation failed", (Throwable)e);
            }
        }
        try {
            autoNumber = autoNumberHome.findByPrimaryKey(collectionName);
        }
        catch (FinderException e) {
            try {
                autoNumber = autoNumberHome.create(collectionName);
            }
            catch (CreateException x) {
                log.error((Object)"operation failed", (Throwable)x);
            }
            catch (RemoteException x) {
                log.error((Object)"operation failed", (Throwable)x);
            }
            try {
                autoNumber.setValue(new Integer(0));
            }
            catch (RemoteException x) {
                log.error((Object)"operation failed", (Throwable)x);
            }
        }
        catch (RemoteException e) {
            log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            value = autoNumber.getValue();
            autoNumber.setValue(new Integer(value + 1));
        }
        catch (RemoteException e) {
            log.error((Object)"operation failed", (Throwable)e);
        }
        return value;
    }

    public static synchronized void resetAutoNumber(String collectionName) {
        AutoNumberFactory.setAutoNumber(collectionName, new Integer(0));
    }

    public static synchronized void setAutoNumber(String collectionName, Integer value) {
        AutoNumber autoNumber = null;
        if (autoNumberHome == null) {
            try {
                autoNumberHome = (AutoNumberHome)new InitialContext().lookup("JBossUtilAutoNumber");
            }
            catch (NamingException e) {
                log.error((Object)"operation failed", (Throwable)e);
            }
        }
        try {
            autoNumber = autoNumberHome.findByPrimaryKey(collectionName);
        }
        catch (FinderException e) {
            try {
                autoNumber = autoNumberHome.create(collectionName);
            }
            catch (CreateException x) {
                log.error((Object)"operation failed", (Throwable)x);
            }
            catch (RemoteException x) {
                log.error((Object)"operation failed", (Throwable)x);
            }
        }
        catch (RemoteException e) {
            log.error((Object)"operation failed", (Throwable)e);
        }
        try {
            autoNumber.setValue(value);
        }
        catch (RemoteException e) {
            log.error((Object)"operation failed", (Throwable)e);
        }
    }
}

