/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.config.Configuration;
import org.jacorb.notification.engine.DefaultTaskExecutor;
import org.jacorb.notification.engine.FilterConsumerAdminTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.FilterSupplierAdminTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.util.AbstractPoolablePool;

public class DefaultTaskFactory
implements Disposable,
TaskFactory {
    private final TaskExecutor filterTaskExecutor_;
    private final int filterWorkerPoolSize_;
    private final AbstractPoolablePool filterProxyConsumerTaskPool_ = new AbstractPoolablePool("FilterProxyConsumerTaskPool"){

        public Object newInstance() {
            return new FilterProxyConsumerTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };
    private final AbstractPoolablePool filterSupplierAdminTaskPool_ = new AbstractPoolablePool("FilterSupplierAdminTaskPool"){

        public Object newInstance() {
            return new FilterSupplierAdminTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };
    private final AbstractPoolablePool filterConsumerAdminTaskPool_ = new AbstractPoolablePool("FilterConsumerAdminTaskPool"){

        public Object newInstance() {
            return new FilterConsumerAdminTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };
    private final AbstractPoolablePool filterProxySupplierTaskPool_ = new AbstractPoolablePool("FilterProxySupplierTaskPool"){

        public Object newInstance() {
            return new FilterProxySupplierTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };

    public DefaultTaskFactory(Configuration configuration) {
        this.filterWorkerPoolSize_ = configuration.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.filterTaskExecutor_ = new DefaultTaskExecutor("FilterThread", this.filterWorkerPoolSize_);
        this.configure(configuration);
    }

    private void configure(Configuration configuration) {
        this.filterProxyConsumerTaskPool_.configure(configuration);
        this.filterProxySupplierTaskPool_.configure(configuration);
        this.filterConsumerAdminTaskPool_.configure(configuration);
        this.filterSupplierAdminTaskPool_.configure(configuration);
    }

    public void dispose() {
        this.filterTaskExecutor_.dispose();
        this.filterProxyConsumerTaskPool_.dispose();
        this.filterProxySupplierTaskPool_.dispose();
        this.filterConsumerAdminTaskPool_.dispose();
        this.filterSupplierAdminTaskPool_.dispose();
    }

    private FilterProxyConsumerTask newFilterProxyConsumerTask() {
        return (FilterProxyConsumerTask)this.filterProxyConsumerTaskPool_.lendObject();
    }

    public Schedulable newFilterProxyConsumerTask(Message message) {
        FilterProxyConsumerTask filterProxyConsumerTask = this.newFilterProxyConsumerTask();
        filterProxyConsumerTask.setMessage(message);
        filterProxyConsumerTask.setCurrentFilterStage(new FilterStage[]{message.getInitialFilterStage()});
        return filterProxyConsumerTask;
    }

    private FilterSupplierAdminTask newFilterSupplierAdminTask() {
        return (FilterSupplierAdminTask)this.filterSupplierAdminTaskPool_.lendObject();
    }

    public Schedulable newFilterSupplierAdminTask(FilterProxyConsumerTask filterProxyConsumerTask) {
        FilterSupplierAdminTask filterSupplierAdminTask = this.newFilterSupplierAdminTask();
        if (filterProxyConsumerTask.getFilterStageToBeProcessed().length != 1) {
            throw new RuntimeException();
        }
        filterSupplierAdminTask.setMessage(filterProxyConsumerTask.removeMessage());
        filterSupplierAdminTask.setCurrentFilterStage(filterProxyConsumerTask.getFilterStageToBeProcessed());
        filterSupplierAdminTask.setSkip(filterProxyConsumerTask.getSkip());
        return filterSupplierAdminTask;
    }

    private FilterConsumerAdminTask newFilterConsumerAdminTask() {
        return (FilterConsumerAdminTask)this.filterConsumerAdminTaskPool_.lendObject();
    }

    public Schedulable newFilterConsumerAdminTask(FilterSupplierAdminTask filterSupplierAdminTask) {
        FilterConsumerAdminTask filterConsumerAdminTask = this.newFilterConsumerAdminTask();
        filterConsumerAdminTask.setMessage(filterSupplierAdminTask.removeMessage());
        filterConsumerAdminTask.setCurrentFilterStage(filterSupplierAdminTask.getFilterStageToBeProcessed());
        return filterConsumerAdminTask;
    }

    private FilterProxySupplierTask newFilterProxySupplierTask() {
        return (FilterProxySupplierTask)this.filterProxySupplierTaskPool_.lendObject();
    }

    public Schedulable newFilterProxySupplierTask(FilterConsumerAdminTask filterConsumerAdminTask) {
        FilterProxySupplierTask filterProxySupplierTask = this.newFilterProxySupplierTask();
        filterProxySupplierTask.setMessage(filterConsumerAdminTask.removeMessage());
        FilterStage[] filterStageArray = filterConsumerAdminTask.getFilterStageToBeProcessed();
        filterProxySupplierTask.setCurrentFilterStage(filterStageArray);
        return filterProxySupplierTask;
    }

    public void enqueueMessage(FilterStage[] filterStageArray, Message message) {
        this.enqueueMessage(filterStageArray, message, FilterProxySupplierTask.EMPTY_MAP);
    }

    private void enqueueMessage(FilterStage[] filterStageArray, Message message, FilterProxySupplierTask.AlternateMessageMap alternateMessageMap) {
        for (int i = 0; i < filterStageArray.length; ++i) {
            MessageConsumer messageConsumer = filterStageArray[i].getMessageConsumer();
            Message message2 = alternateMessageMap.getAlternateMessage(filterStageArray[i]);
            if (message2 != null) {
                messageConsumer.queueMessage(message2);
                continue;
            }
            messageConsumer.queueMessage(message);
        }
    }

    public void enqueueMessage(FilterProxySupplierTask filterProxySupplierTask) {
        Message message = filterProxySupplierTask.removeMessage();
        FilterStage[] filterStageArray = filterProxySupplierTask.getFilterStageToBeProcessed();
        this.enqueueMessage(filterStageArray, message, filterProxySupplierTask.changedMessages_);
    }
}

