/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static Object invoke(Method method, Object target, Object[] arguments) throws Throwable {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        try {
            return method.invoke(target, arguments);
        }
        catch (Throwable t) {
            if (target != null && t instanceof IllegalArgumentException) {
                Class<?> clazz = method.getDeclaringClass();
                if (!clazz.isInstance(target)) {
                    throw new IllegalArgumentException("Wrong target. " + target.getClass().getName() + " is not a " + clazz.getName());
                }
            } else if (target == null && !Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Null target calling: " + method);
            }
            throw ReflectionUtils.handleErrors(method.getName(), Strings.defaultToString((Object)target), method.getParameterTypes(), arguments, t);
        }
    }

    public static Object newInstance(Class<?> clazz) throws Throwable {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("new", clazz.getName(), null, null, t);
        }
    }

    public static Object newInstance(String className, ClassLoader cl) throws Throwable {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        Class<?> clazz = Class.forName(className, false, cl);
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("new", clazz.getName(), null, null, t);
        }
    }

    public static Object newInstance(String className) throws Throwable {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ReflectionUtils.newInstance(className, cl);
    }

    public static Object newInstance(Constructor<?> constructor, Object[] arguments) throws Throwable {
        if (constructor == null) {
            throw new IllegalArgumentException("Null constructor");
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("new", constructor.getClass().getName(), constructor.getParameterTypes(), arguments, t);
        }
    }

    public static Object getField(Field field, Object target) throws Throwable {
        if (field == null) {
            throw new IllegalArgumentException("Null field");
        }
        if (target == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Null target getting " + field.getDeclaringClass().getName() + "." + field.getName());
        }
        try {
            return field.get(target);
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("get", field, target, null, t);
        }
    }

    public static Object setField(Field field, Object target, Object value) throws Throwable {
        if (field == null) {
            throw new IllegalArgumentException("Null field");
        }
        if (target == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Null target getting " + field.getDeclaringClass().getName() + "." + field.getName());
        }
        try {
            field.set(target, value);
            return null;
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("set", field, target, value, t);
        }
    }

    protected static Object arrayInfo(Object ... objects) {
        return objects == null ? "<null>" : Arrays.asList(objects);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        Method[] methods = clazz.getDeclaredMethods();
        if (methods.length != 0) {
            for (Method method : methods) {
                Object[] methodParams;
                if (!method.getName().equals(name) || !((methodParams = method.getParameterTypes()).length != 0 ? Arrays.equals(methodParams, parameterTypes) : parameterTypes == null || parameterTypes.length == 0)) continue;
                return method;
            }
        }
        return ReflectionUtils.findMethod(clazz.getSuperclass(), name, parameterTypes);
    }

    public static Method findExactMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = ReflectionUtils.findMethod(clazz, name, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(clazz + "." + name + " - " + ReflectionUtils.arrayInfo(parameterTypes));
        }
        return method;
    }

    public static Field findField(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
        }
        return ReflectionUtils.findField(clazz.getSuperclass(), name);
    }

    public static Field findExactField(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = ReflectionUtils.findField(clazz, name);
        if (field == null) {
            throw new NoSuchFieldException(clazz + "." + name);
        }
        return field;
    }

    public static Constructor<?> findConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length != 0) {
            for (Constructor<?> constructor : constructors) {
                Object[] constructorParams = constructor.getParameterTypes();
                if (!(constructorParams.length != 0 ? Arrays.equals(constructorParams, parameterTypes) : parameterTypes == null || parameterTypes.length == 0)) continue;
                return constructor;
            }
        }
        return ReflectionUtils.findConstructor(clazz.getSuperclass(), parameterTypes);
    }

    public static Constructor<?> findExactConstructor(Class<?> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<?> constructor = ReflectionUtils.findConstructor(clazz, parameterTypes);
        if (constructor == null) {
            throw new NoSuchMethodException(clazz + " - " + ReflectionUtils.arrayInfo(parameterTypes));
        }
        return constructor;
    }

    public static Throwable handleErrors(String context, Object target, Class<?>[] parameters, Object[] arguments, Throwable t) throws Throwable {
        if (t instanceof IllegalArgumentException) {
            if (target == null) {
                throw new IllegalArgumentException("Null target for " + context);
            }
            ArrayList<String> expected = new ArrayList<String>();
            if (parameters != null) {
                for (Class<?> parameter : parameters) {
                    expected.add(parameter.getName());
                }
            }
            ArrayList<String> actual = new ArrayList<String>();
            if (arguments != null) {
                for (Object argument : arguments) {
                    if (argument == null) {
                        actual.add(null);
                        continue;
                    }
                    actual.add(argument.getClass().getName());
                }
            }
            throw new IllegalArgumentException("Wrong arguments. " + context + " for target " + target + " expected=" + expected + " actual=" + actual);
        }
        if (t instanceof InvocationTargetException) {
            throw ((InvocationTargetException)t).getTargetException();
        }
        throw t;
    }

    public static Throwable handleErrors(String context, Field field, Object target, Object value, Throwable t) throws Throwable {
        if (t instanceof IllegalArgumentException) {
            Class<?> clazz = field.getDeclaringClass();
            if (!(clazz.isInstance(target) || Modifier.isStatic(field.getModifiers()) && target == null)) {
                throw new IllegalArgumentException("Wrong target. " + target.getClass().getName() + " is not a " + clazz.getName());
            }
            String valueType = null;
            if (value != null) {
                valueType = value.getClass().getName();
            }
            throw new IllegalArgumentException("Error invoking field " + context + " for target " + target + " field " + field.getName() + " expected=" + field.getType().getName() + " actual=" + valueType);
        }
        throw t;
    }
}

