/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.reflect.plugins.bytecode.bytes.BytecodePrimitive;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AnnotationProxy;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmClassBytesFactory;
import org.jboss.reflect.plugins.bytecode.bytes.asm.SecurityActions;
import org.jboss.reflect.util.objectweb.asm.AnnotationVisitor;
import org.jboss.reflect.util.objectweb.asm.Attribute;
import org.jboss.reflect.util.objectweb.asm.ClassVisitor;
import org.jboss.reflect.util.objectweb.asm.FieldVisitor;
import org.jboss.reflect.util.objectweb.asm.Label;
import org.jboss.reflect.util.objectweb.asm.MethodVisitor;
import org.jboss.reflect.util.objectweb.asm.Type;
import org.jboss.reflect.util.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Map<Class<?>, Map<String, String>> RETURN_TYPES_BY_NAME = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, Map<String, Object>> DEFAULT_VALUES = Collections.synchronizedMap(new WeakHashMap());

    Util() {
    }

    static String jvmNameToTypeInfoName(String jvmName) {
        if (jvmName == null) {
            return null;
        }
        return jvmName.replace('/', '.');
    }

    static AnnotationVisitor createAnnotationVisitor(ParentReader parent, ClassLoader loader, String desc) {
        return new AnnotationReader(parent, loader, desc);
    }

    private static Class<?> loadClass(ClassLoader loader, String desc) {
        try {
            BytecodePrimitive primitive = BytecodePrimitive.valueOf(desc);
            if (primitive != null) {
                return primitive.getPrimitiveClass();
            }
            return SecurityActions.loadClass(loader, Util.toClassName(desc).replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class '" + Util.toClassName(desc) + "' with loader " + loader);
        }
    }

    private static Object handleSpecial(ClassLoader loader, Object value) {
        if (value.getClass() == Type.class) {
            String desc = ((Type)value).getDescriptor();
            int arrayDims = 0;
            while (desc.charAt(arrayDims) == '[') {
                ++arrayDims;
            }
            Class<?> clazz = Util.loadClass(loader, desc.substring(arrayDims));
            if (arrayDims == 0) {
                return clazz;
            }
            int[] dims = new int[arrayDims];
            return Array.newInstance(clazz, dims).getClass();
        }
        return value;
    }

    private static String toClassName(String desc) {
        if (desc.charAt(0) != 'L' && desc.length() <= 2 && desc.charAt(desc.length() - 1) != ';') {
            throw new IllegalArgumentException("Not a proper descriptor " + desc);
        }
        return desc.substring(1, desc.length() - 1);
    }

    static class EmptyMethodVisitor
    implements MethodVisitor {
        EmptyMethodVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitCode() {
        }

        public void visitEnd() {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitTypeInsn(int opcode, String type) {
        }

        public void visitVarInsn(int opcode, int var) {
        }
    }

    static class EmptyFieldVisitor
    implements FieldVisitor {
        EmptyFieldVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }
    }

    static abstract class EmptyClassVisitor
    implements ClassVisitor {
        EmptyClassVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value, int index) {
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions, int byteCodeIndex) {
            return null;
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayReader
    implements AnnotationVisitor,
    ParentReader {
        final ParentReader parent;
        final ClassLoader loader;
        final String name;
        final Class<?> type;
        final List<Object> values = new ArrayList<Object>();

        ArrayReader(ParentReader parent, ClassLoader loader, String name, Class<?> type) {
            this.parent = parent;
            this.name = name;
            this.type = type;
            this.loader = loader;
        }

        @Override
        public void visit(String name, Object value) {
            this.values.add(Util.handleSpecial(this.loader, value));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationReader(this, this.loader, desc);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            throw new IllegalArgumentException("Can't have nested arrays");
        }

        @Override
        public void visitEnd() {
            Object[] src = this.values.toArray();
            Object[] dest = (Object[])Array.newInstance(this.type, this.values.size());
            for (int i = 0; i < src.length; ++i) {
                dest[i] = this.type.cast(src[i]);
            }
            this.parent.setValueInParent(this.name, dest);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            Class enumClass = Util.loadClass(this.loader, desc);
            this.values.add(Enum.valueOf(enumClass, value));
        }

        @Override
        public void setValueInParent(String name, Object value) {
            this.values.add(value);
        }
    }

    private static class NestedAnnotationReader
    extends AnnotationReader {
        private final String name;

        NestedAnnotationReader(ParentReader parent, ClassLoader loader, String name, String desc) {
            super(parent, loader, desc);
            this.name = name;
        }

        public void visitEnd() {
            this.handleDefaultAttributes();
            this.parent.setValueInParent(this.name, this.createAnnotation());
        }
    }

    private static class AnnotationReader
    implements AnnotationVisitor,
    ParentReader {
        Map<String, Object> values = new HashMap<String, Object>();
        final ParentReader parent;
        final ClassLoader loader;
        Class<?> clazz;
        ClassBytes classBytes;
        Map<String, String> returnTypesByName;

        AnnotationReader(ParentReader parent, ClassLoader loader, String desc) {
            this.parent = parent;
            this.loader = loader;
            this.clazz = Util.loadClass(loader, desc);
            this.classBytes = AsmClassBytesFactory.INSTANCE.loadClassBytes(loader, Util.toClassName(desc));
            if (this.classBytes == null) {
                throw new IllegalStateException("Could not load bytes for " + Util.toClassName(desc) + " in " + loader);
            }
            this.returnTypesByName = (Map)RETURN_TYPES_BY_NAME.get(this.clazz);
            if (this.returnTypesByName == null) {
                AllAnnotationAttributesReader allAnnotationAttributesReader = new AllAnnotationAttributesReader();
                ((AsmClassBytes)this.classBytes).getReader().accept(allAnnotationAttributesReader, 8359);
                this.returnTypesByName = Collections.unmodifiableMap(allAnnotationAttributesReader.returnTypesByName);
                RETURN_TYPES_BY_NAME.put(this.clazz, this.returnTypesByName);
            }
        }

        public void setValueInParent(String name, Object value) {
            this.values.put(name, value);
        }

        public void visit(String name, Object value) {
            this.values.put(name, Util.handleSpecial(this.loader, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new NestedAnnotationReader(this, this.loader, name, desc);
        }

        public AnnotationVisitor visitArray(String name) {
            return new ArrayReader(this, this.loader, name, Util.loadClass(this.loader, this.returnTypesByName.get(name).substring(1)));
        }

        Object createAnnotation() {
            try {
                return AnnotationProxy.createProxy(this.values, this.clazz);
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating annotation proxy for " + this.clazz.getName());
            }
        }

        void handleDefaultAttributes() {
            Map<Object, Object> defaults = null;
            for (String name : this.returnTypesByName.keySet()) {
                Object value;
                if (this.values.containsKey(name)) continue;
                if (defaults == null) {
                    defaults = (Map)DEFAULT_VALUES.get(this.clazz);
                    if (defaults == null) {
                        if (this.classBytes instanceof AsmClassBytes) {
                            DefaultAnnotationAttributeReader defaultsReader = new DefaultAnnotationAttributeReader(this.loader, this.returnTypesByName);
                            ((AsmClassBytes)this.classBytes).getReader().accept(defaultsReader, 139431);
                            defaults = defaultsReader.defaultAttributesByName;
                        } else {
                            defaults = Collections.emptyMap();
                        }
                    }
                    DEFAULT_VALUES.put(this.clazz, Collections.unmodifiableMap(defaults));
                }
                if ((value = defaults.get(name)) == null) {
                    throw new IllegalStateException("No value and no default for " + name + " in " + this.clazz.getName());
                }
                this.values.put(name, value);
            }
        }

        public void visitEnd() {
            this.handleDefaultAttributes();
            this.parent.setValueInParent(null, this.createAnnotation());
        }

        public void visitEnum(String name, String desc, String value) {
            Class enumClass = Util.loadClass(this.loader, desc);
            this.values.put(name, Enum.valueOf(enumClass, value));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DefaultAnnotationAttributeReader
        extends EmptyVisitor {
            final Map<String, Object> defaultAttributesByName = new HashMap<String, Object>();
            final ClassLoader loader;
            final Map<String, String> returnTypesByName;

            public DefaultAnnotationAttributeReader(ClassLoader loader, Map<String, String> returnTypesByName) {
                this.loader = loader;
                this.returnTypesByName = returnTypesByName;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions, int byteCodeIndex) {
                return new AnnotationDefaultReader(name);
            }

            private class AnnotationDefaultReader
            extends EmptyMethodVisitor
            implements AnnotationVisitor,
            ParentReader {
                String name;

                private AnnotationDefaultReader(String name) {
                    this.name = name;
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return this;
                }

                public void setValueInParent(String name, Object value) {
                    DefaultAnnotationAttributeReader.this.defaultAttributesByName.put(this.name, value);
                }

                public void visit(String name, Object value) {
                    DefaultAnnotationAttributeReader.this.defaultAttributesByName.put(this.name, Util.handleSpecial(DefaultAnnotationAttributeReader.this.loader, value));
                }

                public AnnotationVisitor visitAnnotation(String name, String desc) {
                    return new NestedAnnotationReader(this, DefaultAnnotationAttributeReader.this.loader, this.name, desc);
                }

                public AnnotationVisitor visitArray(String name) {
                    return new ArrayReader(this, DefaultAnnotationAttributeReader.this.loader, this.name, Util.loadClass(DefaultAnnotationAttributeReader.this.loader, DefaultAnnotationAttributeReader.this.returnTypesByName.get(this.name).substring(1)));
                }

                public void visitEnum(String name, String desc, String value) {
                    Class enumClass = Util.loadClass(DefaultAnnotationAttributeReader.this.loader, desc);
                    DefaultAnnotationAttributeReader.this.defaultAttributesByName.put(this.name, Enum.valueOf(enumClass, value));
                }
            }
        }

        private static class AllAnnotationAttributesReader
        extends EmptyVisitor {
            Map<String, String> returnTypesByName = new HashMap<String, String>();

            private AllAnnotationAttributesReader() {
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions, int byteCodeIndex) {
                if (name.charAt(0) != '<' && desc.charAt(1) == ')') {
                    this.returnTypesByName.put(name, desc.substring(2));
                }
                return null;
            }
        }
    }

    static interface ParentReader {
        public void setValueInParent(String var1, Object var2);
    }
}

