/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    static Object invokeMethod(final MethodInfo m, final Object o, final Object ... args) throws Throwable {
        if (System.getSecurityManager() == null) {
            return m.invoke(o, args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        return m.invoke(o, args);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetSystemClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        static final GetSystemClassLoaderAction INSTANCE = new GetSystemClassLoaderAction();

        GetSystemClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }
}

