/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.jboss.xnio.log.Logger;

final class OrderedExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(OrderedExecutor.class);
    private final LinkedList<Runnable> tasks = new LinkedList();
    private boolean running;
    private final Executor parent;
    private final Runnable runner;

    OrderedExecutor(Executor parent) {
        this.parent = parent;
        this.runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Runnable task;
                    LinkedList linkedList = OrderedExecutor.this.tasks;
                    synchronized (linkedList) {
                        task = (Runnable)OrderedExecutor.this.tasks.poll();
                        if (task == null) {
                            OrderedExecutor.this.running = false;
                            return;
                        }
                    }
                    try {
                        task.run();
                        continue;
                    }
                    catch (Throwable t) {
                        log.error(t, "Runnable task %s failed", (Object)task);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) {
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(command);
            if (!this.running) {
                this.running = true;
                boolean ok = false;
                try {
                    this.parent.execute(this.runner);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        this.running = false;
                    }
                }
            }
        }
    }
}

