/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.propertyservice;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;

class FileLocator {
    private static final String absolutePath = "abs://";
    private static final String pct20 = "%20";
    private static final int pct20len = 3;

    FileLocator() {
    }

    static String locateFile(String findFile) throws FileNotFoundException {
        if (findFile == null) {
            throw new FileNotFoundException("locateFile: null file name");
        }
        String testAbsolutePath = new File(findFile).getAbsolutePath();
        if (testAbsolutePath.equals(findFile)) {
            return testAbsolutePath;
        }
        if (findFile.startsWith(absolutePath)) {
            return findFile.substring(absolutePath.length());
        }
        String fullPathName = FileLocator.locateByProperty(findFile);
        if (fullPathName != null) {
            return fullPathName;
        }
        URL url = FileLocator.locateByResource(findFile);
        if (url != null) {
            fullPathName = url.getFile();
            int pos = 0;
            int len = fullPathName.length();
            int start = 0;
            StringBuffer decodedPathName = new StringBuffer();
            while ((pos = fullPathName.indexOf(pct20, start)) != -1) {
                decodedPathName.append(fullPathName.substring(start, pos));
                decodedPathName.append(' ');
                start = pos + 3;
            }
            if (start < len) {
                decodedPathName.append(fullPathName.substring(start, len));
            }
            fullPathName = decodedPathName.toString();
            if (FileLocator.platformIsWindows()) {
                fullPathName = fullPathName.substring(1, fullPathName.length());
            }
            return fullPathName;
        }
        throw new FileNotFoundException("locateFile: file not found: " + findFile);
    }

    private static synchronized String locateByProperty(String findFile) {
        String fullPathName = null;
        String dir = null;
        File f = null;
        if (findFile == null) {
            return null;
        }
        try {
            dir = System.getProperty("user.dir");
            if (dir != null) {
                fullPathName = dir + File.separatorChar + findFile;
                f = new File(fullPathName);
            }
            if (f != null && f.exists()) {
                return fullPathName;
            }
            dir = System.getProperty("user.home");
            if (dir != null) {
                fullPathName = dir + File.separatorChar + findFile;
                f = new File(fullPathName);
            }
            if (f != null && f.exists()) {
                return fullPathName;
            }
            dir = System.getProperty("java.home");
            if (dir != null) {
                fullPathName = dir + File.separatorChar + findFile;
                f = new File(fullPathName);
            }
            if (f != null && f.exists()) {
                return fullPathName;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static URL locateByResource(String findFile) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(findFile);
        if (url == null) {
            url = FileLocator.class.getResource("/" + findFile);
        }
        return url;
    }

    private static boolean platformIsWindows() {
        return File.separatorChar == '\\';
    }
}

