/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TransactionImporterImple
implements TransactionImporter {
    private static ConcurrentHashMap<Xid, SubordinateTransaction> _transactions = new ConcurrentHashMap();

    @Override
    public SubordinateTransaction importTransaction(Xid xid) throws XAException {
        return this.importTransaction(xid, 0);
    }

    @Override
    public SubordinateTransaction importTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        SubordinateTransaction imported = this.getImportedTransaction(xid);
        if (imported == null) {
            imported = new TransactionImple(timeout, xid);
            _transactions.put(new XidImple(xid), imported);
        }
        return imported;
    }

    @Override
    public TransactionImple recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple recovered = new TransactionImple(actId);
        if (recovered.baseXid() == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple tx2 = (TransactionImple)_transactions.get(recovered.baseXid());
        if (tx2 == null) {
            _transactions.put(recovered.baseXid(), recovered);
            recovered.recordTransaction();
            return recovered;
        }
        return tx2;
    }

    @Override
    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        SubordinateTransaction tx2 = _transactions.get(new XidImple(xid));
        if (tx2 == null) {
            return null;
        }
        if (!tx2.activated()) {
            tx2.recover();
            return tx2;
        }
        return tx2;
    }

    @Override
    public void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        _transactions.remove(new XidImple(xid));
    }
}

