/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;

public class OSEntryBean
implements OSEntryBeanMBean {
    protected UidWrapper w;

    public OSEntryBean() {
        this.w = new UidWrapper(Uid.nullUid());
    }

    public OSEntryBean(UidWrapper w) {
        this.w = w;
    }

    public void register(String name) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("Registering: " + name));
        }
        JMXServer.getAgent().registerMBean(name, this);
    }

    public void unregister(String name) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("Unregistering: " + name));
        }
        JMXServer.getAgent().unregisterMBean(name);
    }

    public void register() {
        this.register(this.getName());
    }

    public void unregister() {
        this.unregister(this.getName());
    }

    public String getName() {
        return this.w.getName();
    }

    @Override
    public String getType() {
        return this.w.getType();
    }

    public String type() {
        return this.getType();
    }

    public boolean activate() {
        return false;
    }

    public Uid getUid(AbstractRecord rec) {
        return rec.get_uid();
    }

    @Override
    public String getId() {
        return this.w.getUid().stringForm();
    }

    public Uid getUid() {
        return this.w.getUid();
    }

    public StringBuilder toString(String prefix, StringBuilder sb) {
        return sb.append(prefix).append('\t').append(this.getId()).append('\n');
    }
}

