/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.ConcurrentReferenceHashMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

public final class ClassLoaderLogContextSelector
implements LogContextSelector {
    private static final Permission REGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("registerLogContext", null);
    private static final Permission UNREGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("unregisterLogContext", null);
    private static final Gateway GATEWAY = AccessController.doPrivileged(new PrivilegedAction<Gateway>(){

        @Override
        public Gateway run() {
            return new Gateway();
        }
    });
    private final LogContextSelector defaultSelector;
    private final ConcurrentMap<ClassLoader, LogContext> contextMap = new ConcurrentReferenceHashMap<ClassLoader, LogContext>(16, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.WEAK, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));

    public ClassLoaderLogContextSelector(LogContextSelector defaultSelector) {
        this.defaultSelector = defaultSelector;
    }

    public ClassLoaderLogContextSelector() {
        this(LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
    }

    @Override
    public LogContext getLogContext() {
        for (Class caller : GATEWAY.getClassContext()) {
            LogContext context = (LogContext)this.contextMap.get(caller.getClassLoader());
            if (context == null) continue;
            return context;
        }
        return this.defaultSelector.getLogContext();
    }

    public void registerLogContext(ClassLoader classLoader, LogContext logContext) throws IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_LOG_CONTEXT_PERMISSION);
        }
        if (this.contextMap.putIfAbsent(classLoader, logContext) != null) {
            throw new IllegalArgumentException("ClassLoader instance is already registered to a log context (" + classLoader + ")");
        }
    }

    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(UNREGISTER_LOG_CONTEXT_PERMISSION);
        }
        return this.contextMap.remove(classLoader, logContext);
    }

    private static final class Gateway
    extends SecurityManager {
        private Gateway() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

