/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.invocationhandler;

import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.sis.Interceptor;

class ObjectMethodsInterceptor
implements Interceptor {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private Object original;

    ObjectMethodsInterceptor(Object original) {
        this.original = original;
    }

    public Object invoke(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        if (method.equals(METHOD_EQUALS)) {
            return this.original.equals(context.getParameters()[0]);
        }
        if (method.equals(METHOD_HASH_CODE)) {
            return this.original.hashCode();
        }
        if (method.equals(METHOD_TO_STRING)) {
            return this.original.toString();
        }
        return context.proceed();
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            METHOD_HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            METHOD_TO_STRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

