/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanOp;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.console.twiddle.command.OpCountComparator;
import org.jboss.util.Strings;
import org.jboss.util.propertyeditor.PropertyEditors;

public class InvokeCommand
extends MBeanServerCommand {
    public static final int QUERY_FIRST = 0;
    public static final int QUERY_ALL = 1;
    private int type = 0;
    private String query;
    private String opName;
    private List opArgs = new ArrayList(5);

    public InvokeCommand() {
        super("invoke", "Invoke an operation on an MBean");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <query> <operation> (<arg>)*");
        out.println();
        out.println("options:");
        out.println("    -q, --query-type[=<type>]    Treat object name as a query");
        out.println("    --                           Stop processing options");
        out.println();
        out.println("query type:");
        out.println("    f[irst]    Only invoke on the first matching name [default]");
        out.println("    a[ll]      Invoke on all matching names");
    }

    private void processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:q:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("query-type", 2, null, 113)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            block0 : switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.query = arg;
                            this.log.debug((Object)("query: " + this.query));
                            break block0;
                        }
                        case 1: {
                            this.opName = arg;
                            this.log.debug((Object)("operation name: " + this.opName));
                            break block0;
                        }
                    }
                    this.opArgs.add(arg);
                    break;
                }
                case 113: {
                    String arg = getopt.getOptarg();
                    if (arg.equals("f") || arg.equals("first")) {
                        this.type = 0;
                    } else if (arg.equals("a") || arg.equals("all")) {
                        this.type = 1;
                    } else {
                        throw new CommandException("Invalid query type: " + arg);
                    }
                    this.log.debug((Object)("Query type: " + this.type));
                    break;
                }
            }
        }
    }

    private void invoke(ObjectName name) throws Exception {
        PropertyEditor editor;
        this.log.debug((Object)("Invoke " + name));
        MBeanServerConnection server = this.getMBeanServer();
        MBeanInfo info = server.getMBeanInfo(name);
        MBeanOperationInfo[] ops = info.getOperations();
        MBeanOp inputOp = new MBeanOp(this.opName, this.opArgs.size());
        MBeanOp matchOp = null;
        ArrayList<MBeanOp> opList = new ArrayList<MBeanOp>();
        for (int i = 0; i < ops.length; ++i) {
            MBeanOperationInfo opInfo = ops[i];
            MBeanOp op = new MBeanOp(opInfo.getName(), opInfo.getSignature());
            if (inputOp.equals(op)) {
                matchOp = op;
                break;
            }
            opList.add(op);
        }
        if (matchOp == null) {
            OpCountComparator comparator = new OpCountComparator();
            Collections.sort(opList, comparator);
            int match = Collections.binarySearch(opList, inputOp, comparator);
            if (match >= 0) {
                matchOp = (MBeanOp)opList.get(match);
                if ((match = comparator.compare(matchOp, inputOp)) != 0) {
                    throw new CommandException("MBean has no such operation named '" + this.opName + "' with signature compatible with: " + this.opArgs);
                }
            } else {
                throw new CommandException("MBean has no such operation named '" + this.opName + "' with signature compatible with: " + this.opArgs);
            }
        }
        int count = matchOp.getArgCount();
        Object[] params = new Object[count];
        for (int i = 0; i < count; ++i) {
            String argType = matchOp.getArgType(i);
            editor = PropertyEditors.getEditor((String)argType);
            editor.setAsText((String)this.opArgs.get(i));
            params[i] = editor.getValue();
        }
        this.log.debug((Object)("Using params: " + Strings.join((Object[])params, (String)",")));
        Object result = server.invoke(name, this.opName, params, matchOp.getSignature());
        this.log.debug((Object)("Raw result: " + result));
        if (!this.context.isQuiet()) {
            String resultText = null;
            if (result != null) {
                try {
                    editor = PropertyEditors.getEditor(result.getClass());
                    editor.setValue(result);
                    resultText = editor.getAsText();
                    this.log.debug((Object)("Converted result: " + resultText));
                }
                catch (RuntimeException e) {
                    resultText = result.toString();
                }
            } else {
                resultText = "'null'";
            }
            PrintWriter out = this.context.getWriter();
            out.println(resultText);
            out.flush();
        }
        this.closeServer();
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        if (this.query == null) {
            throw new CommandException("Missing MBean query");
        }
        if (this.opName == null) {
            throw new CommandException("Missing operation name");
        }
        this.log.debug((Object)("operation arguments: " + this.opArgs));
        ObjectName[] names = this.queryMBeans(this.query);
        if (this.type == 0) {
            names = new ObjectName[]{names[0]};
        }
        for (int i = 0; i < names.length; ++i) {
            this.invoke(names[i]);
        }
    }
}

