/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.php;

import org.jboss.web.php.PhpThread;

public class Library {
    private static String[] NAMES = new String[]{"php5servlet", "libphp5servlet"};
    private static Library engine = null;
    private static boolean inited = false;
    static PhpThread phpthread = null;
    public static int PHP_MAJOR_VERSION = 0;
    public static int PHP_MINOR_VERSION = 0;
    public static int PHP_PATCH_VERSION = 0;

    private Library() {
        boolean loaded = false;
        String err = "";
        for (int i = 0; i < NAMES.length; ++i) {
            try {
                System.loadLibrary(NAMES[i]);
                loaded = true;
            }
            catch (Throwable e) {
                if (i > 0) {
                    err = err + ", ";
                }
                err = err + e.getMessage();
            }
            if (loaded) break;
        }
        if (!loaded) {
            err = err + "(";
            err = err + System.getProperty("java.library.path");
            err = err + ")";
            throw new UnsatisfiedLinkError(err);
        }
    }

    private Library(String libraryName) {
        System.loadLibrary(libraryName);
    }

    public static native boolean startup();

    public static native void shutdown();

    private static native int version(int var0);

    public static boolean initialize(String libraryName) throws Exception {
        if (engine == null) {
            engine = libraryName == null ? new Library() : new Library(libraryName);
            PHP_MAJOR_VERSION = Library.version(1);
            PHP_MINOR_VERSION = Library.version(2);
            PHP_PATCH_VERSION = Library.version(3);
        }
        phpthread = new PhpThread();
        phpthread.setDaemon(true);
        phpthread.start();
        while (!inited && phpthread.isAlive()) {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        return inited;
    }

    public static boolean isInitialized() {
        return inited;
    }

    public static void terminate() {
        if (engine != null) {
            if (phpthread != null && phpthread.isAlive()) {
                phpthread.interrupt();
            }
            engine = null;
            inited = false;
        }
    }

    public static void StartUp() {
        inited = Library.startup();
    }
}

