/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.ModuleRegistry;
import org.jboss.classpool.plugins.jbosscl.DomainRegistry;
import org.jboss.classpool.plugins.jbosscl.JBossClDelegatingClassPoolFactory;
import org.jboss.classpool.plugins.jbosscl.RegisterModuleCallback;
import org.jboss.classpool.plugins.jbosscl.VFSClassLoaderDomainRegistry;
import org.jboss.classpool.scoped.ScopedClassPoolFactory;
import org.jboss.classpool.spi.ClassPoolRepository;

public class JBossClClassPoolConfig {
    private static volatile JBossClClassPoolConfig config;
    private final DomainRegistry domainRegistry;
    private final RegisterModuleCallback registerModuleCallback;
    private ClassLoading classLoading;
    private JBossClDelegatingClassPoolFactory classPoolFactory;
    private ClassPoolRepository classPoolRepository;

    private JBossClClassPoolConfig(DomainRegistry domainRegistry, RegisterModuleCallback registerModuleCallback, JBossClDelegatingClassPoolFactory classPoolFactory) {
        this.domainRegistry = domainRegistry;
        this.registerModuleCallback = registerModuleCallback;
        this.classPoolFactory = classPoolFactory;
        this.classPoolRepository = ClassPoolRepository.getInstance();
        this.classPoolRepository.setClassPoolFactory((ScopedClassPoolFactory)classPoolFactory);
    }

    public static JBossClClassPoolConfig getInstance() {
        if (config == null) {
            JBossClClassPoolConfig.initialize();
        }
        return config;
    }

    private static synchronized void initialize() {
        if (config != null) {
            return;
        }
        VFSClassLoaderDomainRegistry domainRegistry = VFSClassLoaderDomainRegistry.getInstance();
        RegisterModuleCallback registerModuleCallback = new RegisterModuleCallback(domainRegistry);
        JBossClDelegatingClassPoolFactory classPoolFactory = new JBossClDelegatingClassPoolFactory(domainRegistry, registerModuleCallback);
        config = new JBossClClassPoolConfig(domainRegistry, registerModuleCallback, classPoolFactory);
    }

    public DomainRegistry getDomainRegistry() {
        return this.domainRegistry;
    }

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public void setClassLoading(ClassLoading cl) {
        if (cl != null) {
            cl.addModuleRegistry((ModuleRegistry)this.registerModuleCallback);
        } else if (this.classLoading != null) {
            this.classLoading.removeModuleRegistry((ModuleRegistry)this.registerModuleCallback);
        }
        this.classLoading = cl;
    }

    public RegisterModuleCallback getRegisterModuleCallback() {
        return this.registerModuleCallback;
    }

    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.classPoolFactory;
    }

    public void setClassPoolFactory(JBossClDelegatingClassPoolFactory classPoolFactory) {
        this.classPoolFactory = classPoolFactory;
    }

    public ClassPoolRepository getClassPoolRepository() {
        return this.classPoolRepository;
    }
}

