/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"})
public class RpcDispatcherAnycastTest
extends ChannelTestBase {
    RpcDispatcher disp;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    JChannel ch;
    JChannel ch2;
    JChannel ch3;

    @BeforeMethod
    void setUp() throws Exception {
        this.ch = this.createChannel(true, 3);
        ServerObject obj = new ServerObject(null);
        this.disp = new RpcDispatcher((Channel)this.ch, null, null, obj);
        this.ch.connect("RpcDispatcherAnycastTest");
        obj.setAddress(this.ch.getAddress());
        this.ch2 = this.createChannel(this.ch);
        ServerObject obj2 = new ServerObject(null);
        this.disp2 = new RpcDispatcher((Channel)this.ch2, null, null, obj2);
        this.ch2.connect("RpcDispatcherAnycastTest");
        obj2.setAddress(this.ch2.getAddress());
        this.ch3 = this.createChannel(this.ch);
        ServerObject obj3 = new ServerObject(null);
        this.disp3 = new RpcDispatcher((Channel)this.ch3, null, null, obj3);
        this.ch3.connect("RpcDispatcherAnycastTest");
        obj3.setAddress(this.ch3.getAddress());
    }

    @AfterMethod
    void tearDown() throws Exception {
        this.ch3.close();
        this.disp3.stop();
        this.ch2.close();
        this.disp2.stop();
        this.ch.close();
        this.disp.stop();
    }

    public void testUnserializableValue() {
        Vector<Address> members = this.ch.getView().getMembers();
        System.out.println("members: " + members);
        assert (members.size() > 1) : "we should have more than 1 member";
        Vector<Address> subset = Util.pickSubset(members, 0.2);
        System.out.println("subset: " + subset);
        Util.sleep(1000L);
        RspList rsps = this.disp.callRemoteMethods(subset, "foo", null, (Class[])null, 2, 0L, false);
        System.out.println("rsps (no anycast): " + rsps);
        rsps = this.disp.callRemoteMethods(subset, "foo", null, (Class[])null, 2, 0L, true);
        System.out.println("rsps (with anycast): " + rsps);
    }

    static class ServerObject {
        Address addr;

        public ServerObject(Address addr) {
            this.addr = addr;
        }

        public Address foo() {
            return this.addr;
        }

        public void setAddress(Address localAddress) {
            this.addr = localAddress;
        }
    }
}

