/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.api.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    private SecurityActions() {
    }

    static Object newInstance(final Class<?> clazz, final ClassLoader cl) throws IllegalArgumentException, InstantiationException {
        final boolean setDefiningCl = cl != null;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    Thread current = null;
                    ClassLoader oldCl = null;
                    if (setDefiningCl) {
                        current = Thread.currentThread();
                        oldCl = current.getContextClassLoader();
                        current.setContextClassLoader(cl);
                    }
                    try {
                        Object t = clazz.newInstance();
                        return t;
                    }
                    finally {
                        if (setDefiningCl) {
                            current.setContextClassLoader(oldCl);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            throw new RuntimeException("Error in instanciation", cause);
        }
    }

    static ClassLoader getTccl() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

