/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.ejbref.resolver.ejb30.impl;

import java.util.Iterator;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.ejbref.resolver.ejb30.impl.EJB30MetaDataBasedEjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.ejb30.impl.MetaDataBasedEjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReference;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.spi.UnresolvableReferenceException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class FirstMatchEjbReferenceResolver
implements EjbReferenceResolver {
    private static Logger logger = Logger.getLogger(FirstMatchEjbReferenceResolver.class);
    protected MetaDataBasedEjbReferenceResolver metadataBasedEjbReferenceResolver = new EJB30MetaDataBasedEjbReferenceResolver();

    public String resolveEjb(DeploymentUnit du, EjbReference reference) {
        String mappedName = reference.getMappedName();
        if (mappedName != null && mappedName.trim().length() > 0) {
            logger.debug((Object)("Bypassing resolution, using mappedName of " + reference));
            return mappedName;
        }
        String jndiName = null;
        DeploymentUnit root = du.getTopLevel();
        jndiName = this.resolveEjbFromRoot(root, reference);
        if (jndiName == null) {
            throw new UnresolvableReferenceException("Could not resolve reference " + reference + " for " + DeploymentUnit.class.getSimpleName() + " " + du);
        }
        return jndiName;
    }

    protected String resolveEjbFromRoot(DeploymentUnit rootDu, EjbReference reference) {
        String jndiName;
        block2: {
            DeploymentUnit child;
            List children;
            jndiName = null;
            JBossMetaData metadata = this.getMetaData(rootDu);
            if (metadata != null) {
                jndiName = this.getMetaDataBasedEjbReferenceResolver().resolveEjb(reference, metadata, rootDu.getClassLoader());
            }
            if (jndiName != null || (children = rootDu.getChildren()) == null) break block2;
            Iterator i$ = children.iterator();
            while (i$.hasNext() && (jndiName = this.resolveEjbFromRoot(child = (DeploymentUnit)i$.next(), reference)) == null) {
            }
        }
        return jndiName;
    }

    protected JBossMetaData getMetaData(DeploymentUnit du) {
        return (JBossMetaData)du.getAttachment(EJB30MetaDataBasedEjbReferenceResolver.DU_ATTACHMENT_NAME_METADATA, JBossMetaData.class);
    }

    protected MetaDataBasedEjbReferenceResolver getMetaDataBasedEjbReferenceResolver() {
        return this.metadataBasedEjbReferenceResolver;
    }
}

