/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.test.support;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.test.support.IsolatedClassLoaderTest;
import org.jboss.classloader.test.support.MockClassLoaderHelper;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;
import org.jboss.logging.Logger;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.logging.LoggingPlugin;
import org.jboss.test.security.PolicyPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedClassLoaderTestHelper {
    private ClassLoaderSystem system;
    private ClassLoaderDomain domain;
    private ClassLoaderPolicy policy;

    public ClassLoaderDomain getDomain() {
        return this.domain;
    }

    public ClassLoaderSystem getSystem() {
        return this.system;
    }

    public ClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ClassLoaderPolicy policy) {
        this.policy = policy;
    }

    public static Set<String> getParentPackages() {
        HashSet<String> result = new HashSet<String>();
        result.add(Test.class.getPackage().getName());
        result.add(TestSetup.class.getPackage().getName());
        result.add(AbstractTestCaseWithSetup.class.getPackage().getName());
        result.add(Logger.class.getPackage().getName());
        result.add(LoggingPlugin.class.getPackage().getName());
        result.add(PolicyPlugin.class.getPackage().getName());
        result.add(ClassLoaderSystem.class.getPackage().getName());
        result.add(IsolatedClassLoaderTest.class.getPackage().getName());
        String pkgString = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jboss.test.parent.pkgs");
            }
        });
        if (pkgString != null) {
            StringTokenizer tok = new StringTokenizer(pkgString, ",");
            while (tok.hasMoreTokens()) {
                String pkg = tok.nextToken();
                result.add(pkg.trim());
            }
        }
        return result;
    }

    public Class<?> initializeClassLoader(Class<?> clazz, boolean importAll, Class<?> ... packages) {
        MockClassLoaderPolicy policy = new MockClassLoaderPolicy();
        HashSet classes = new HashSet();
        classes.add(clazz);
        classes.addAll(Arrays.asList(packages));
        policy.setImportAll(importAll);
        policy.setPathsAndPackageNames(classes.toArray(new Class[classes.size()]));
        return this.initializeClassLoader(clazz, policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderPolicy policy) {
        DefaultClassLoaderSystem system = new DefaultClassLoaderSystem();
        return this.initializeClassLoader(clazz, (ClassLoaderSystem)system, policy, IsolatedClassLoaderTestHelper.getParentPackages());
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderPolicy policy) {
        return this.initializeClassLoader(clazz, system, policy, IsolatedClassLoaderTestHelper.getParentPackages());
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderPolicy policy, Set<String> parentPackages) {
        String[] parentPkgs = parentPackages.toArray(new String[parentPackages.size()]);
        return this.initializeClassLoader(clazz, system, policy, parentPkgs);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderPolicy policy, String ... parentPackages) {
        PackageClassFilter filter = new PackageClassFilter(parentPackages);
        filter.setIncludeJava(true);
        return this.initializeClassLoader(clazz, system, filter, ClassFilterUtils.NOTHING, policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassFilter parentFilter, boolean importAll, Class<?> ... packages) {
        MockClassLoaderPolicy policy = new MockClassLoaderPolicy();
        HashSet classes = new HashSet();
        classes.add(clazz);
        classes.addAll(Arrays.asList(packages));
        policy.setImportAll(importAll);
        policy.setPathsAndPackageNames(classes.toArray(new Class[classes.size()]));
        return this.initializeClassLoader(clazz, parentFilter, (ClassLoaderPolicy)policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassFilter parentFilter, ClassLoaderPolicy policy) {
        DefaultClassLoaderSystem system = new DefaultClassLoaderSystem();
        return this.initializeClassLoader(clazz, (ClassLoaderSystem)system, parentFilter, policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassFilter parentFilter, ClassLoaderPolicy policy) {
        Set<String> parentPackages = IsolatedClassLoaderTestHelper.getParentPackages();
        String[] parentPkgs = parentPackages.toArray(new String[parentPackages.size()]);
        PackageClassFilter filter = new PackageClassFilter(parentPkgs);
        filter.setIncludeJava(true);
        CombiningClassFilter beforeFilter = CombiningClassFilter.create(filter, parentFilter);
        ParentPolicy parentPolicy = new ParentPolicy(beforeFilter, ClassFilterUtils.NOTHING);
        return this.initializeClassLoader(clazz, system, parentPolicy, policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassFilter beforeFilter, ClassFilter afterFilter, ClassLoaderPolicy policy) {
        ParentPolicy parentPolicy = new ParentPolicy(beforeFilter, afterFilter);
        return this.initializeClassLoader(clazz, system, parentPolicy, policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ParentPolicy parentPolicy, ClassLoaderPolicy policy) {
        ClassLoaderDomain domain = system.createAndRegisterDomain("TEST", parentPolicy);
        return this.initializeClassLoader(clazz, system, domain, policy);
    }

    public Class<?> initializeClassLoader(Class<?> clazz, ClassLoaderSystem system, ClassLoaderDomain domain, ClassLoaderPolicy policy) {
        this.system = system;
        this.domain = domain;
        this.policy = policy;
        ClassLoader classLoader = system.registerClassLoaderPolicy(domain, policy);
        try {
            clazz = classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load test class in isolated classloader " + clazz, e);
        }
        return clazz;
    }

    public ClassLoader createClassLoader(String name, boolean importAll, String ... packages) throws Exception {
        MockClassLoaderPolicy policy = MockClassLoaderHelper.createMockClassLoaderPolicy(name);
        policy.setImportAll(importAll);
        policy.setPathsAndPackageNames(packages);
        return this.createClassLoader(policy);
    }

    public ClassLoader createClassLoader(MockClassLoaderPolicy policy) throws Exception {
        ClassLoaderDomain domain = this.getDomain();
        return this.createClassLoader(domain, policy);
    }

    public ClassLoader createClassLoader(String domainName, MockClassLoaderPolicy policy) throws Exception {
        ClassLoaderSystem system = this.getSystem();
        ClassLoaderDomain domain = system.getDomain(domainName);
        return this.createClassLoader(domain, policy);
    }

    public ClassLoader createClassLoader(ClassLoaderDomain domain, MockClassLoaderPolicy policy) throws Exception {
        ClassLoaderSystem system = this.getSystem();
        return MockClassLoaderHelper.registerMockClassLoader(system, domain, policy);
    }

    public void unregisterClassLoader(ClassLoader classLoader) throws Exception {
        ClassLoaderSystem system = this.getSystem();
        system.unregisterClassLoader(classLoader);
    }

    public List<? extends DelegateLoader> createDefaultDelegates() {
        return this.createDelegates(this.getPolicy());
    }

    public List<? extends DelegateLoader> createDelegates(ClassLoaderPolicy ... policies) {
        ArrayList<FilteredDelegateLoader> delegates = new ArrayList<FilteredDelegateLoader>();
        for (ClassLoaderPolicy policy : policies) {
            delegates.add(new FilteredDelegateLoader(policy));
        }
        return delegates;
    }

    public ClassLoaderDomain createScopedClassLoaderDomainParentFirst(String name) {
        return this.createScopedClassLoaderDomain(name, ParentPolicy.BEFORE, this.getDomain());
    }

    public ClassLoaderDomain createScopedClassLoaderDomainParentLast(String name) {
        return this.createScopedClassLoaderDomain(name, ParentPolicy.AFTER_BUT_JAVA_BEFORE, this.getDomain());
    }

    public ClassLoaderDomain createScopedClassLoaderDomain(String name, ParentPolicy parentPolicy) {
        return this.createScopedClassLoaderDomain(name, parentPolicy, this.getDomain());
    }

    public ClassLoaderDomain createScopedClassLoaderDomain(String name, ParentPolicy parentPolicy, Loader parent) {
        ClassLoaderSystem system = this.getSystem();
        return system.createAndRegisterDomain(name, parentPolicy, parent);
    }

    public void unregisterDomain(String name) {
        ClassLoaderSystem system = this.getSystem();
        ClassLoaderDomain domain = system.getDomain(name);
        if (domain == null) {
            throw new IllegalStateException("Domain is not registered: " + name);
        }
        system.unregisterDomain(domain);
    }
}

