/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.CacheLoader;
import org.jboss.classloader.spi.ClassFoundEvent;
import org.jboss.classloader.spi.ClassFoundHandler;
import org.jboss.classloader.spi.ClassLoaderDomainMBean;
import org.jboss.classloader.spi.ClassLoaderEvent;
import org.jboss.classloader.spi.ClassLoaderEventHandler;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ClassNotFoundEvent;
import org.jboss.classloader.spi.ClassNotFoundHandler;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.ShutdownPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderDomain
extends BaseClassLoaderDomain
implements ClassLoaderDomainMBean,
MBeanRegistration,
ClassNotFoundHandler,
ClassFoundHandler {
    private static final Logger log = Logger.getLogger(ClassLoaderDomain.class);
    private String name;
    private ParentPolicy parentPolicy = ParentPolicy.BEFORE;
    private Loader parent;
    private ShutdownPolicy shutdownPolicy;
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private boolean useLoadClassForParent = false;
    private List<ClassNotFoundHandler> classNotFoundHandlers;
    private List<ClassFoundHandler> classFoundHandlers;
    private List<ClassLoaderEventHandler> classLoaderEventHandlers;

    public ClassLoaderDomain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.fixUpParent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public ParentPolicy getParentPolicy() {
        return this.parentPolicy;
    }

    public void setParentPolicy(ParentPolicy parentPolicy) {
        if (parentPolicy == null) {
            throw new IllegalArgumentException("Null parent policy");
        }
        this.parentPolicy = parentPolicy;
    }

    @Override
    public String getParentPolicyName() {
        return this.parentPolicy.toString();
    }

    @Override
    public ShutdownPolicy getShutdownPolicy() {
        return this.shutdownPolicy;
    }

    public void setShutdownPolicy(ShutdownPolicy shutdownPolicy) {
        this.shutdownPolicy = shutdownPolicy;
    }

    public Loader getParent() {
        return this.parent;
    }

    public void setParent(Loader parent) {
        this.parent = parent;
        this.fixUpParent();
    }

    @Override
    public boolean isUseLoadClassForParent() {
        return this.useLoadClassForParent;
    }

    public void setUseLoadClassForParent(boolean useLoadClassForParent) {
        this.useLoadClassForParent = useLoadClassForParent;
    }

    @Override
    public ObjectName getParentDomain() {
        if (this.parent == null || !(this.parent instanceof ClassLoaderDomain)) {
            return null;
        }
        ClassLoaderDomain parentDomain = (ClassLoaderDomain)this.parent;
        return parentDomain.getObjectName();
    }

    @Override
    public String getParentDomainName() {
        if (this.parent == null || !(this.parent instanceof ClassLoaderDomain)) {
            return null;
        }
        ClassLoaderDomain parentDomain = (ClassLoaderDomain)this.parent;
        return parentDomain.getName();
    }

    @Override
    public ObjectName getSystem() {
        ClassLoaderSystem system = (ClassLoaderSystem)this.getClassLoaderSystem();
        if (system == null) {
            return null;
        }
        return system.getObjectName();
    }

    @Override
    public List<ObjectName> listClassLoaders() {
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (ClassLoader cl : super.getAllClassLoaders()) {
            if (!(cl instanceof RealClassLoader)) continue;
            result.add(((RealClassLoader)cl).getObjectName());
        }
        return result;
    }

    @Override
    public Map<String, List<ObjectName>> listExportingClassLoaders() {
        HashMap<String, List<ObjectName>> result = new HashMap<String, List<ObjectName>>();
        for (Map.Entry<String, List<ClassLoader>> entry : this.getClassLoadersByPackage().entrySet()) {
            ArrayList<ObjectName> names = new ArrayList<ObjectName>();
            for (ClassLoader cl : entry.getValue()) {
                if (!(cl instanceof RealClassLoader)) continue;
                names.add(((RealClassLoader)cl).getObjectName());
            }
            result.put(entry.getKey(), names);
        }
        return result;
    }

    @Override
    public List<ObjectName> listExportingClassLoaders(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Null package name");
        }
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (ClassLoader cl : this.getClassLoaders(packageName)) {
            if (!(cl instanceof RealClassLoader)) continue;
            result.add(((RealClassLoader)cl).getObjectName());
        }
        return result;
    }

    @Override
    public ObjectName findClassLoaderForClass(String name) throws ClassNotFoundException {
        final Class<?> clazz = this.loadClass(null, name, true);
        if (clazz == null) {
            return null;
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        if (cl != null && cl instanceof RealClassLoader) {
            return ((RealClassLoader)cl).getObjectName();
        }
        return null;
    }

    @Override
    public Set<URL> loadResources(String name) throws IOException {
        TreeSet<URL> result = new TreeSet<URL>(ClassLoaderUtils.URLComparator.INSTANCE);
        this.getResources(name, result);
        return result;
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        builder.append("name=").append(this.getName());
        builder.append(" parentPolicy=").append(this.getParentPolicy());
        builder.append(" parent=");
        Loader parent = this.getParent();
        if (parent != null) {
            builder.append(parent);
        } else {
            builder.append(this.getParentClassLoader());
        }
    }

    public void addClassNotFoundHandler(ClassNotFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classNotFoundHandlers == null) {
            this.classNotFoundHandlers = new CopyOnWriteArrayList<ClassNotFoundHandler>();
        }
        this.classNotFoundHandlers.add(handler);
    }

    public void removeClassNotFoundHandler(ClassNotFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classNotFoundHandlers == null) {
            return;
        }
        this.classNotFoundHandlers.remove(handler);
    }

    @Override
    public boolean classNotFound(ClassNotFoundEvent event) {
        String className = event.getClassName();
        ClassNotFoundHandler parent = null;
        Loader parentLoader = this.getParent();
        if (parentLoader instanceof ClassNotFoundHandler) {
            parent = (ClassNotFoundHandler)((Object)parentLoader);
        } else {
            ClassLoaderPolicy parentPolicy = this.getClassLoaderPolicy(parentLoader);
            if (parentPolicy != null) {
                parent = parentPolicy;
            }
        }
        boolean parentResult = false;
        if (parent != null) {
            parentResult = parent.classNotFound(event);
        }
        if (parentResult && this.getParentPolicy().getBeforeFilter().matchesClassName(className)) {
            return true;
        }
        if (this.classNotFoundHandlers != null && !this.classNotFoundHandlers.isEmpty()) {
            for (ClassNotFoundHandler handler : this.classNotFoundHandlers) {
                try {
                    if (!handler.classNotFound(event)) continue;
                    return true;
                }
                catch (Throwable t) {
                    log.warn((Object)("Error invoking classNotFoundHandler: " + handler), t);
                }
            }
        }
        if (parentResult && this.getParentPolicy().getAfterFilter().matchesClassName(className)) {
            return true;
        }
        ClassLoaderSystem system = (ClassLoaderSystem)this.getClassLoaderSystem();
        return system != null && system.classNotFound(event);
    }

    public void addClassFoundHandler(ClassFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classFoundHandlers == null) {
            this.classFoundHandlers = new CopyOnWriteArrayList<ClassFoundHandler>();
        }
        this.classFoundHandlers.add(handler);
    }

    public void removeClassFoundHandler(ClassFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classFoundHandlers == null) {
            return;
        }
        this.classFoundHandlers.remove(handler);
    }

    @Override
    public void classFound(ClassFoundEvent event) {
        ClassLoaderSystem system;
        ClassFoundHandler parent = null;
        Loader parentLoader = this.getParent();
        if (parentLoader instanceof ClassFoundHandler) {
            parent = (ClassFoundHandler)((Object)parentLoader);
        } else {
            ClassLoaderPolicy parentPolicy = this.getClassLoaderPolicy(parentLoader);
            if (parentPolicy != null) {
                parent = parentPolicy;
            }
        }
        if (parent != null) {
            parent.classFound(event);
        }
        if (this.classFoundHandlers != null && !this.classFoundHandlers.isEmpty()) {
            for (ClassFoundHandler handler : this.classFoundHandlers) {
                try {
                    handler.classFound(event);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error invoking classFoundHandler: " + handler), t);
                }
            }
        }
        if ((system = (ClassLoaderSystem)this.getClassLoaderSystem()) != null) {
            system.classFound(event);
        }
    }

    public void addClassLoaderEventHandler(ClassLoaderEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classLoaderEventHandlers == null) {
            this.classLoaderEventHandlers = new CopyOnWriteArrayList<ClassLoaderEventHandler>();
        }
        this.classLoaderEventHandlers.add(handler);
    }

    public void removeClassLoaderEventHandler(ClassLoaderEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classLoaderEventHandlers == null) {
            return;
        }
        this.classLoaderEventHandlers.remove(handler);
    }

    private void fireRegisterClassLoader(ClassLoaderEvent event) {
        ClassLoaderSystem system;
        if (this.classLoaderEventHandlers != null && !this.classLoaderEventHandlers.isEmpty()) {
            for (ClassLoaderEventHandler handler : this.classLoaderEventHandlers) {
                try {
                    handler.fireRegisterClassLoader(event);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error invoking classLoaderEventHandler: " + handler), t);
                }
            }
        }
        if ((system = (ClassLoaderSystem)this.getClassLoaderSystem()) == null) {
            return;
        }
        system.fireRegisterClassLoader(event);
    }

    private void fireUnregisterClassLoader(ClassLoaderEvent event) {
        ClassLoaderSystem system;
        if (this.classLoaderEventHandlers != null && !this.classLoaderEventHandlers.isEmpty()) {
            for (ClassLoaderEventHandler handler : this.classLoaderEventHandlers) {
                try {
                    handler.fireUnregisterClassLoader(event);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error invoking classLoaderEventHandler: " + handler), t);
                }
            }
        }
        if ((system = (ClassLoaderSystem)this.getClassLoaderSystem()) == null) {
            return;
        }
        system.fireUnregisterClassLoader(event);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{").append(this.name).append('}');
        return builder.toString();
    }

    @Override
    protected Class<?> loadClassBefore(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesClassName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.loadClassFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Class<?> loadClassAfter(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesClassName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.loadClassFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Class<?> loadClassFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not loading from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " load class from parent " + name + " parent=" + this.parent));
        }
        return parentLoader.loadClass(name);
    }

    @Override
    protected Loader findBeforeLoader(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.findLoaderFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Loader findAfterLoader(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.findLoaderFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Loader findLoaderFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not loading from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " load from parent " + name + " parent=" + this.parent));
        }
        if (parentLoader instanceof ClassLoaderDomain) {
            ClassLoaderDomain parentDomain = (ClassLoaderDomain)parentLoader;
            return parentDomain.findLoader(name);
        }
        if (parentLoader.getResource(name) != null) {
            return parentLoader;
        }
        return null;
    }

    @Override
    protected URL beforeGetResource(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.getResourceFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected URL afterGetResource(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.getResourceFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected URL getResourceFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting resource from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " get resource from parent " + name + " parent=" + parentLoader));
        }
        URL result = parentLoader.getResource(name);
        if (trace) {
            if (result != null) {
                log.trace((Object)(this + " got resource from parent " + name + " parent=" + parentLoader + " " + result));
            } else {
                log.trace((Object)(this + " resource not found in parent " + name + " parent=" + parentLoader));
            }
        }
        return result;
    }

    @Override
    protected void beforeGetResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            this.getResourcesFromParent(name, urls);
        } else if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
    }

    @Override
    protected void afterGetResources(String name, Set<URL> urls) throws IOException {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesResourcePath(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            this.getResourcesFromParent(name, urls);
        } else if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
    }

    protected void getResourcesFromParent(String name, Set<URL> urls) throws IOException {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting resources from non-existant parent"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " get resources from parent " + name + " parent=" + parentLoader));
        }
        parentLoader.getResources(name, urls);
    }

    @Override
    protected Package beforeGetPackage(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesPackageName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent beforeFilter=" + filter));
            }
            return this.getPackageFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent beforeFilter=" + filter));
        }
        return null;
    }

    @Override
    protected Package afterGetPackage(String name) {
        boolean trace = log.isTraceEnabled();
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesPackageName(name)) {
            if (trace) {
                log.trace((Object)(this + " " + name + " matches parent afterFilter=" + filter));
            }
            return this.getPackageFromParent(name);
        }
        if (trace) {
            log.trace((Object)(this + " " + name + " does NOT match parent afterFilter=" + filter));
        }
        return null;
    }

    protected Package getPackageFromParent(String name) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting package from non-existant parent"));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)(this + " get package from parent " + name + " parent=" + parentLoader));
        }
        Package result = parentLoader.getPackage(name);
        if (trace) {
            if (result != null) {
                log.trace((Object)(this + " got package from parent " + name + " parent=" + parentLoader + " " + result));
            } else {
                log.trace((Object)(this + " package not found in parent " + name + " parent=" + parentLoader));
            }
        }
        return result;
    }

    @Override
    protected void beforeGetPackages(Set<Package> packages) {
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        this.getPackagesFromParent(packages, filter);
    }

    @Override
    protected void afterGetPackages(Set<Package> packages) {
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        this.getPackagesFromParent(packages, filter);
    }

    protected void getPackagesFromParent(Set<Package> packages, ClassFilter filter) {
        Loader parentLoader = this.getParent();
        boolean trace = log.isTraceEnabled();
        if (parentLoader == null) {
            if (trace) {
                log.trace((Object)(this + " not getting packages from non-existant parent"));
            }
            return;
        }
        if (trace) {
            log.trace((Object)(this + " get packages from parent=" + parentLoader + " filter=" + filter));
        }
        HashSet<Package> parentPackages = new HashSet<Package>();
        parentLoader.getPackages(parentPackages);
        for (Package parentPackage : parentPackages) {
            if (filter.matchesPackageName(parentPackage.getName())) {
                if (trace) {
                    log.trace((Object)(this + " parentPackage=" + parentPackage + " matches filter=" + filter));
                }
                packages.add(parentPackage);
                continue;
            }
            if (!trace) continue;
            log.trace((Object)(this + " parentPackage=" + parentPackage + " does NOT match filter=" + filter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixUpParent() {
        try {
            ClassLoader classLoader;
            if (this.parent == null && (classLoader = this.getParentClassLoader()) != null) {
                this.parent = AccessController.doPrivileged(new PrivilegedAction<Loader>(){

                    @Override
                    public Loader run() {
                        return new ClassLoaderToLoaderAdapter(classLoader);
                    }
                });
            }
        }
        finally {
            if (!(this.parent instanceof ClassLoaderDomain) && !(this.parent instanceof BaseClassLoaderSource)) {
                this.setUseLoadClassForParent(true);
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            for (ClassLoader cl : this.getAllClassLoaders()) {
                this.registerClassLoaderMBean(cl);
            }
        } else {
            this.postDeregister();
        }
    }

    @Override
    public void preDeregister() throws Exception {
        for (ClassLoader cl : this.getAllClassLoaders()) {
            this.unregisterClassLoaderMBean(cl);
        }
    }

    @Override
    public void postDeregister() {
        this.mbeanServer = null;
        this.objectName = null;
    }

    @Override
    protected void afterRegisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
        this.registerClassLoaderMBean(classLoader);
        this.fireRegisterClassLoader(new ClassLoaderEvent(this, classLoader));
    }

    @Override
    protected void beforeUnregisterClassLoader(ClassLoader classLoader, ClassLoaderPolicy policy) {
        this.fireUnregisterClassLoader(new ClassLoaderEvent(this, classLoader));
        this.unregisterClassLoaderMBean(classLoader);
    }

    protected void registerClassLoaderMBean(ClassLoader cl) {
        if (this.mbeanServer == null) {
            return;
        }
        if (cl instanceof RealClassLoader) {
            ObjectName name = ((RealClassLoader)cl).getObjectName();
            try {
                this.mbeanServer.registerMBean(cl, name);
            }
            catch (Exception e) {
                log.warn((Object)("Error registering classloader: " + cl), (Throwable)e);
            }
        }
    }

    protected void unregisterClassLoaderMBean(ClassLoader cl) {
        if (this.mbeanServer == null) {
            return;
        }
        if (cl instanceof RealClassLoader) {
            ObjectName name = ((RealClassLoader)cl).getObjectName();
            try {
                this.mbeanServer.unregisterMBean(name);
            }
            catch (Exception e) {
                log.warn((Object)("Error unregistering classloader: " + cl), (Throwable)e);
            }
        }
    }

    @Override
    protected Class<?> checkCacheBefore(BaseClassLoader classLoader, String name, String path, boolean allExports) {
        if (this.parent == null || !(this.parent instanceof CacheLoader)) {
            return null;
        }
        ClassFilter filter = this.getParentPolicy().getBeforeFilter();
        if (filter.matchesClassName(name)) {
            CacheLoader loader = (CacheLoader)this.parent;
            return loader.checkClassCache(classLoader, name, path, allExports);
        }
        return null;
    }

    @Override
    protected Class<?> checkCacheAfter(BaseClassLoader classLoader, String name, String path, boolean allExports) {
        if (this.parent == null || !(this.parent instanceof CacheLoader) || !this.isBlackListedClass(path)) {
            return null;
        }
        ClassFilter filter = this.getParentPolicy().getAfterFilter();
        if (filter.matchesClassName(name)) {
            CacheLoader loader = (CacheLoader)this.parent;
            return loader.checkClassCache(classLoader, name, path, allExports);
        }
        return null;
    }
}

