/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    private static final Method getClassLoader = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Method method = BaseClassLoaderSource.class.getDeclaredMethod("getClassLoader", new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot get classloader from " + BaseClassLoaderSource.class.getName(), e);
            }
        }
    });

    SecurityActions() {
    }

    static ClassLoader getClassLoader(BaseClassLoaderSource clSource) {
        try {
            return (ClassLoader)getClassLoader.invoke((Object)clSource, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static Module getModuleForClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Module>(){

            @Override
            public Module run() {
                return ClassLoading.getModuleForClassLoader((ClassLoader)classLoader);
            }
        });
    }

    public static ClassLoader getClassLoaderForModule(final Module module) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoading.getClassLoaderForModule((Module)module);
            }
        });
    }
}

