/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.cluster.BroadcastGroup;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUIDGenerator;

public class BroadcastGroupImpl
implements BroadcastGroup,
Runnable {
    private static final Logger log = Logger.getLogger(BroadcastGroupImpl.class);
    private final String nodeID;
    private final String name;
    private final InetAddress localAddress;
    private final int localPort;
    private final InetAddress groupAddress;
    private final int groupPort;
    private DatagramSocket socket;
    private final List<Pair<TransportConfiguration, TransportConfiguration>> connectorPairs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
    private boolean started;
    private ScheduledFuture<?> future;
    private boolean active;
    private final String uniqueID;
    private NotificationService notificationService;

    public BroadcastGroupImpl(String nodeID, String name, InetAddress localAddress, int localPort, InetAddress groupAddress, int groupPort, boolean active) throws Exception {
        this.nodeID = nodeID;
        this.name = name;
        this.localAddress = localAddress;
        this.localPort = localPort;
        this.groupAddress = groupAddress;
        this.groupPort = groupPort;
        this.active = active;
        this.uniqueID = UUIDGenerator.getInstance().generateStringUUID();
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.localPort != -1) {
            this.socket = new DatagramSocket(this.localPort, this.localAddress);
        } else {
            if (this.localAddress != null) {
                log.warn("local-bind-address specified for broadcast group but no local-bind-port specified so socket will NOT be bound to a local address/port");
            }
            this.socket = new DatagramSocket();
        }
        this.started = true;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.BROADCAST_GROUP_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.socket.close();
        this.started = false;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.BROADCAST_GROUP_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                log.warn("unable to send notification when broadcast group is stopped", e);
            }
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void addConnectorPair(Pair<TransportConfiguration, TransportConfiguration> connectorPair) {
        this.connectorPairs.add(connectorPair);
    }

    @Override
    public synchronized void removeConnectorPair(Pair<TransportConfiguration, TransportConfiguration> connectorPair) {
        this.connectorPairs.remove(connectorPair);
    }

    @Override
    public synchronized int size() {
        return this.connectorPairs.size();
    }

    @Override
    public synchronized void activate() {
        this.active = true;
    }

    @Override
    public synchronized void broadcastConnectors() throws Exception {
        if (!this.active) {
            return;
        }
        HornetQBuffer buff = HornetQBuffers.dynamicBuffer(4096);
        buff.writeString(this.nodeID);
        buff.writeString(this.uniqueID);
        buff.writeInt(this.connectorPairs.size());
        for (Pair<TransportConfiguration, TransportConfiguration> connectorPair : this.connectorPairs) {
            ((TransportConfiguration)connectorPair.a).encode(buff);
            if (connectorPair.b != null) {
                buff.writeBoolean(true);
                ((TransportConfiguration)connectorPair.b).encode(buff);
                continue;
            }
            buff.writeBoolean(false);
        }
        byte[] data = buff.toByteBuffer().array();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.groupAddress, this.groupPort);
        this.socket.send(packet);
    }

    @Override
    public void run() {
        if (!this.started) {
            return;
        }
        try {
            this.broadcastConnectors();
        }
        catch (Exception e) {
            log.error("Failed to broadcast connector configs", e);
        }
    }

    public synchronized void setScheduledFuture(ScheduledFuture<?> future) {
        this.future = future;
    }
}

