/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;

public class PagedMessageImpl
implements PagedMessage {
    private static final Logger log = Logger.getLogger(PagedMessageImpl.class);
    private byte[] largeMessageLazyData;
    private ServerMessage message;
    private long transactionID = -1L;

    public PagedMessageImpl(ServerMessage message, long transactionID) {
        this.message = message;
        this.transactionID = transactionID;
    }

    public PagedMessageImpl(ServerMessage message) {
        this.message = message;
    }

    public PagedMessageImpl() {
    }

    @Override
    public ServerMessage getMessage(StorageManager storage) {
        if (this.largeMessageLazyData != null) {
            this.message = storage.createLargeMessage();
            HornetQBuffer buffer = HornetQBuffers.dynamicBuffer(this.largeMessageLazyData);
            this.message.decodeHeadersAndProperties(buffer);
            this.largeMessageLazyData = null;
        }
        return this.message;
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public void decode(HornetQBuffer buffer) {
        this.transactionID = buffer.readLong();
        boolean isLargeMessage = buffer.readBoolean();
        if (isLargeMessage) {
            int largeMessageHeaderSize = buffer.readInt();
            this.largeMessageLazyData = new byte[largeMessageHeaderSize];
            buffer.readBytes(this.largeMessageLazyData);
        } else {
            buffer.readInt();
            this.message = new ServerMessageImpl(-1L, 50);
            this.message.decode(buffer);
        }
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        buffer.writeBoolean(this.message instanceof LargeServerMessage);
        buffer.writeInt(this.message.getEncodeSize());
        this.message.encode(buffer);
    }

    @Override
    public int getEncodeSize() {
        return 13 + this.message.getEncodeSize();
    }
}

