/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import org.hornetq.api.core.Pair;

public class BridgeConfiguration
implements Serializable {
    private static final long serialVersionUID = -1057244274380572226L;
    private String name;
    private String queueName;
    private String forwardingAddress;
    private String filterString;
    private Pair<String, String> connectorPair;
    private String discoveryGroupName;
    private String transformerClassName;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private int reconnectAttempts;
    private boolean failoverOnServerShutdown;
    private boolean useDuplicateDetection;
    private int confirmationWindowSize;
    private final long clientFailureCheckPeriod;
    private String user;
    private String password;

    public BridgeConfiguration(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts, boolean failoverOnServerShutdown, boolean useDuplicateDetection, int confirmationWindowSize, long clientFailureCheckPeriod, Pair<String, String> connectorPair, String user, String password) {
        this.name = name;
        this.queueName = queueName;
        this.forwardingAddress = forwardingAddress;
        this.filterString = filterString;
        this.transformerClassName = transformerClassName;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.reconnectAttempts = reconnectAttempts;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.useDuplicateDetection = useDuplicateDetection;
        this.confirmationWindowSize = confirmationWindowSize;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectorPair = connectorPair;
        this.user = user;
        this.password = password;
        this.discoveryGroupName = null;
    }

    public BridgeConfiguration(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts, boolean failoverOnServerShutdown, boolean useDuplicateDetection, int confirmationWindowSize, long clientFailureCheckPeriod, String discoveryGroupName, String user, String password) {
        this.name = name;
        this.queueName = queueName;
        this.forwardingAddress = forwardingAddress;
        this.filterString = filterString;
        this.transformerClassName = transformerClassName;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.reconnectAttempts = reconnectAttempts;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.useDuplicateDetection = useDuplicateDetection;
        this.confirmationWindowSize = confirmationWindowSize;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectorPair = null;
        this.discoveryGroupName = discoveryGroupName;
        this.user = user;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public Pair<String, String> getConnectorPair() {
        return this.connectorPair;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public void setConnectorPair(Pair<String, String> connectorPair) {
        this.connectorPair = connectorPair;
    }

    public void setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public void setUseDuplicateDetection(boolean useDuplicateDetection) {
        this.useDuplicateDetection = useDuplicateDetection;
    }

    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

