/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.statistics;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationStatistics
implements Serializable {
    private static final long serialVersionUID = 9153807780893455734L;
    private Map<String, TimeStatistic> ctxStats;
    public volatile int concurrentCalls = 0;
    public volatile int maxConcurrentCalls = 0;
    public long lastResetTime = System.currentTimeMillis();

    public InvocationStatistics() {
        this.ctxStats = new ConcurrentHashMap<String, TimeStatistic>();
    }

    public void updateStats(String ctx, long elapsed) {
        TimeStatistic stat = this.ctxStats.get(ctx);
        if (stat == null) {
            stat = new TimeStatistic();
            this.ctxStats.put(ctx, stat);
        }
        ++stat.count;
        stat.totalTime += elapsed;
        if (stat.minTime > elapsed) {
            stat.minTime = elapsed;
        }
        if (stat.maxTime < elapsed) {
            stat.maxTime = elapsed;
        }
    }

    public void callIn() {
        ++this.concurrentCalls;
        if (this.concurrentCalls > this.maxConcurrentCalls) {
            this.maxConcurrentCalls = this.concurrentCalls;
        }
    }

    public void callOut() {
        --this.concurrentCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Map<String, TimeStatistic> map = this.ctxStats;
        synchronized (map) {
            for (TimeStatistic stat : this.ctxStats.values()) {
                stat.reset();
            }
        }
        this.maxConcurrentCalls = 0;
        this.lastResetTime = System.currentTimeMillis();
    }

    public Map<String, TimeStatistic> getStats() {
        return this.ctxStats;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("(concurrentCalls: ");
        tmp.append(this.concurrentCalls);
        tmp.append(", maxConcurrentCalls: ");
        tmp.append(this.maxConcurrentCalls);
        for (Map.Entry<String, TimeStatistic> entry : this.ctxStats.entrySet()) {
            TimeStatistic stat = entry.getValue();
            tmp.append("[webCtx: ");
            tmp.append(entry.getKey());
            tmp.append(", count=");
            tmp.append(stat.count);
            tmp.append(", minTime=");
            tmp.append(stat.minTime);
            tmp.append(", maxTime=");
            tmp.append(stat.maxTime);
            tmp.append(", totalTime=");
            tmp.append(stat.totalTime);
            tmp.append("];");
        }
        tmp.append(")");
        return tmp.toString();
    }

    public String toXML() {
        StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
        tmp.append(this.concurrentCalls);
        tmp.append("' maxConcurrentCalls='");
        tmp.append(this.maxConcurrentCalls);
        tmp.append("' >\n");
        for (Map.Entry<String, TimeStatistic> entry : this.ctxStats.entrySet()) {
            TimeStatistic stat = entry.getValue();
            tmp.append("<webCtx name='");
            tmp.append(entry.getKey());
            tmp.append("' count='");
            tmp.append(stat.count);
            tmp.append("' minTime='");
            tmp.append(stat.minTime);
            tmp.append("' maxTime='");
            tmp.append(stat.maxTime);
            tmp.append("' totalTime='");
            tmp.append(stat.totalTime);
            tmp.append("' />\n");
        }
        tmp.append("</InvocationStatistics>");
        return tmp.toString();
    }

    public static class TimeStatistic {
        public long count;
        public long minTime = Long.MAX_VALUE;
        public long maxTime;
        public long totalTime;

        public void reset() {
            this.count = 0L;
            this.minTime = Long.MAX_VALUE;
            this.maxTime = 0L;
            this.totalTime = 0L;
        }
    }
}

