/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.jboss.resteasy.cdi.CdiConstructorInjector;
import org.jboss.resteasy.cdi.NoopPropertyInjector;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class CdiInjectorFactory
implements InjectorFactory {
    private static final Logger log = Logger.getLogger(CdiInjectorFactory.class);
    public static final String BEAN_MANAGER_ATTRIBUTE_PREFIX = "org.jboss.weld.environment.servlet.";
    private PropertyInjector noopPropertyInjector = new NoopPropertyInjector();
    private InjectorFactory delegate = ResteasyProviderFactory.getInstance().getInjectorFactory();
    private BeanManager manager = this.lookupBeanManager();
    private ResteasyCdiExtension extension = this.lookupResteasyCdiExtension();
    private Map<Class<?>, Type> sessionBeanInterface = this.extension.getSessionBeanInterface();

    public ConstructorInjector createConstructor(Constructor constructor) {
        Class clazz = constructor.getDeclaringClass();
        if (!this.manager.getBeans(constructor.getDeclaringClass(), new Annotation[0]).isEmpty()) {
            log.debug("Using CdiConstructorInjector for class {0}.", new Object[]{clazz});
            return new CdiConstructorInjector(clazz, this.manager);
        }
        if (this.sessionBeanInterface.containsKey(constructor.getDeclaringClass())) {
            Type intfc = this.sessionBeanInterface.get(clazz);
            log.debug("Using {0} for lookup of Session Bean {1}.", new Object[]{intfc, clazz});
            return new CdiConstructorInjector(intfc, this.manager);
        }
        log.debug("No CDI beans found for {0}. Using default ConstructorInjector.", new Object[]{clazz});
        return this.delegate.createConstructor(constructor);
    }

    public MethodInjector createMethodInjector(Class root, Method method) {
        return this.delegate.createMethodInjector(root, method);
    }

    public PropertyInjector createPropertyInjector(Class resourceClass) {
        if (!this.manager.getBeans((Type)resourceClass, new Annotation[0]).isEmpty() || this.sessionBeanInterface.containsKey(resourceClass)) {
            return this.noopPropertyInjector;
        }
        return this.delegate.createPropertyInjector(resourceClass);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, boolean useDefault) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations, useDefault);
    }

    protected BeanManager lookupBeanManager() {
        BeanManager beanManager = null;
        beanManager = this.lookupBeanManagerInJndi("java:comp/BeanManager");
        if (beanManager != null) {
            log.info("Found BeanManager at java:comp/BeanManager");
            return beanManager;
        }
        beanManager = this.lookupBeanManagerInJndi("java:app/BeanManager");
        if (beanManager != null) {
            log.info("Found BeanManager at java:app/BeanManager");
            return beanManager;
        }
        ServletContext servletContext = (ServletContext)ResteasyProviderFactory.getContextData(ServletContext.class);
        beanManager = (BeanManager)servletContext.getAttribute(BEAN_MANAGER_ATTRIBUTE_PREFIX + BeanManager.class.getName());
        if (beanManager != null) {
            log.debug("Found BeanManager in ServletContext");
            return beanManager;
        }
        beanManager = (BeanManager)servletContext.getAttribute(BeanManager.class.getName());
        if (beanManager != null) {
            log.debug("Found BeanManager in ServletContext");
            return beanManager;
        }
        throw new RuntimeException("Unable to lookup BeanManager.");
    }

    private BeanManager lookupBeanManagerInJndi(String name) {
        try {
            InitialContext ctx = new InitialContext();
            log.debug("Doing a lookup for BeanManager in {0}", new Object[]{name});
            return (BeanManager)ctx.lookup(name);
        }
        catch (NamingException e) {
            log.debug("Unable to obtain BeanManager from {0}", new Object[]{name});
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            log.debug("Unable to perform JNDI lookups. You are probably running on GAE.");
            return null;
        }
    }

    private ResteasyCdiExtension lookupResteasyCdiExtension() {
        Set beans = this.manager.getBeans(ResteasyCdiExtension.class, new Annotation[0]);
        Bean bean = this.manager.resolve(beans);
        if (bean == null) {
            throw new IllegalStateException("Unable to obtain ResteasyCdiExtension instance.");
        }
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return (ResteasyCdiExtension)this.manager.getReference(bean, ResteasyCdiExtension.class, context);
    }
}

