/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.InitialContext;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.DomainSocketFactory;

public class JaasSecurityDomainSocketFactory
extends DomainSocketFactory {
    private static Logger log = Logger.getLogger(JaasSecurityDomainSocketFactory.class);

    public JaasSecurityDomainSocketFactory() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating socket factory: " + this.getClass().getName()));
        }
        SecurityDomain sd = this.getJaasSecurityDomain();
        this.setSecurityDomain(sd);
    }

    public static SocketFactory getDefault() {
        JaasSecurityDomainSocketFactory jsdsf = new JaasSecurityDomainSocketFactory();
        return jsdsf;
    }

    protected SecurityDomain getJaasSecurityDomain() {
        final String name = this.getSystemPropertyName();
        String secDomain = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
        if (secDomain != null) {
            if (!secDomain.startsWith("java:/jaas/") || !secDomain.startsWith("java:jaas/")) {
                secDomain = "java:/jaas/" + secDomain;
            }
            try {
                InitialContext iniCtx = new InitialContext();
                SecurityDomain sd = (SecurityDomain)iniCtx.lookup(secDomain);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created Security Domain object from " + secDomain + ":" + sd.toString()));
                }
                return sd;
            }
            catch (Exception e) {
                log.error((Object)("Failed to create Security Domain '" + secDomain + "'"), (Throwable)e);
            }
        }
        return null;
    }

    protected String getSystemPropertyName() {
        return "org.jboss.security.ssl.domain.name";
    }
}

