/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SubjectFactory;
import org.jboss.security.integration.SecurityActions;

@ManagementObject(name="JBossSecuritySubjectFactory", componentType=@ManagementComponent(type="MCBean", subtype="Security"))
public class JBossSecuritySubjectFactory
implements SubjectFactory {
    protected static Logger log = Logger.getLogger(JBossSecuritySubjectFactory.class);
    protected ISecurityManagement securityManagement;

    @ManagementOperation(description="Create a subject using the modules specified in the 'other' security domain", impact=ManagedOperation.Impact.ReadOnly)
    public Subject createSubject() {
        return this.createSubject("other");
    }

    @ManagementOperation(description="Create a subject using the modules configured in the specified security domain", params={@ManagementParameter(name="securityDomainName", description="The security domain name")}, impact=ManagedOperation.Impact.ReadOnly)
    public Subject createSubject(String securityDomainName) {
        if (this.securityManagement == null) {
            throw new IllegalStateException("SecurityManagement has not been injected");
        }
        Subject subject = new Subject();
        Principal principal = SecurityActions.getPrincipal();
        AuthenticationManager authenticationManager = this.securityManagement.getAuthenticationManager(securityDomainName);
        if (authenticationManager == null) {
            String defaultSecurityDomain = "other";
            if (log.isTraceEnabled()) {
                log.trace((Object)("AuthenticationManager for " + securityDomainName + " not found. Using " + defaultSecurityDomain));
            }
            authenticationManager = this.securityManagement.getAuthenticationManager(defaultSecurityDomain);
        }
        if (!authenticationManager.isValid(principal, SecurityActions.getCredential(), subject)) {
            throw new SecurityException("Unauthenticated caller:" + principal);
        }
        return subject;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }
}

