/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.profile.metadata.plugin.EmptyProfileMetaData;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class TransientProfileActivator {
    private static ProfileKey TRANSIENT_PROFILE_KEY = new ProfileKey("transient-deployments");
    public static final String TRANSIENT_DEPLOYMENT_URL_KEY = "deployment-url";
    private ProfileService ps;

    public static ProfileKey getTransientProfileKey() {
        return TRANSIENT_PROFILE_KEY;
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService profileService) {
        this.ps = profileService;
    }

    public void start() throws Exception {
        TransientDeploymentsProfile profile = new TransientDeploymentsProfile();
        TRANSIENT_PROFILE_KEY = this.ps.registerProfile((ProfileMetaData)new EmptyProfileMetaData(TRANSIENT_PROFILE_KEY.getName()), (Profile)profile);
        this.ps.activateProfile(TRANSIENT_PROFILE_KEY);
        this.ps.validateProfile(TRANSIENT_PROFILE_KEY);
    }

    public void stop() throws Exception {
        this.ps.deactivateProfile(TRANSIENT_PROFILE_KEY);
        this.ps.unregisterProfile(TRANSIENT_PROFILE_KEY);
    }

    public static class TransientDeploymentsProfile
    implements MutableProfile {
        private Map<String, ProfileDeployment> deployments = new ConcurrentHashMap<String, ProfileDeployment>();
        private volatile long lastModified = System.currentTimeMillis();

        public void addDeployment(ProfileDeployment deployment) {
            this.deployments.put(deployment.getName(), deployment);
            this.lastModified = System.currentTimeMillis();
        }

        public void enableModifiedDeploymentChecks(boolean flag) {
        }

        public Collection<ModificationInfo> getModifiedDeployments() {
            return Collections.emptySet();
        }

        public ProfileDeployment removeDeployment(String name) throws NoSuchDeploymentException {
            ProfileDeployment deployment = this.getDeployment(name);
            this.lastModified = System.currentTimeMillis();
            return this.deployments.remove(deployment.getName());
        }

        public ProfileDeployment getDeployment(String name) throws NoSuchDeploymentException {
            ProfileDeployment deployment = this.resolveDeployment(name);
            if (deployment == null) {
                throw new NoSuchDeploymentException(name);
            }
            return deployment;
        }

        public Set<String> getDeploymentNames() {
            return this.deployments.keySet();
        }

        public Collection<ProfileDeployment> getDeployments() {
            return this.deployments.values();
        }

        public ProfileKey getKey() {
            return TRANSIENT_PROFILE_KEY;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean hasDeployment(String name) {
            return this.resolveDeployment(name) != null;
        }

        public boolean isMutable() {
            return true;
        }

        protected ProfileDeployment resolveDeployment(String name) {
            ProfileDeployment deployment = this.deployments.get(name);
            if (deployment == null) {
                for (ProfileDeployment d : this.getDeployments()) {
                    String transientURL = (String)d.getTransientAttachments().getAttachment(TransientProfileActivator.TRANSIENT_DEPLOYMENT_URL_KEY, String.class);
                    if (transientURL != null && transientURL.equals(name)) {
                        deployment = d;
                        break;
                    }
                    if (!d.getSimpleName().equals(name)) continue;
                    deployment = d;
                    break;
                }
            }
            return deployment;
        }
    }
}

