/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.util.SecurityUtility;

public class ServerInvocationHandlerWrapper
implements ServerInvocationHandler {
    private ServerInvocationHandler proxy;

    public ServerInvocationHandlerWrapper(ServerInvocationHandler proxy) {
        this.proxy = proxy;
    }

    @Override
    public void addListener(final InvokerCallbackHandler callbackHandler) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.addListener(callbackHandler);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerInvocationHandlerWrapper.this.proxy.addListener(callbackHandler);
                return null;
            }
        });
    }

    @Override
    public Object invoke(final InvocationRequest invocation) throws Throwable {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.invoke(invocation);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return ServerInvocationHandlerWrapper.this.proxy.invoke(invocation);
                    }
                    catch (Throwable t) {
                        throw new Exception(t);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause.getCause() == null) {
                throw cause;
            }
            throw cause.getCause();
        }
    }

    @Override
    public void removeListener(final InvokerCallbackHandler callbackHandler) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.removeListener(callbackHandler);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerInvocationHandlerWrapper.this.proxy.removeListener(callbackHandler);
                return null;
            }
        });
    }

    @Override
    public void setInvoker(final ServerInvoker invoker) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setInvoker(invoker);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerInvocationHandlerWrapper.this.proxy.setInvoker(invoker);
                return null;
            }
        });
    }

    @Override
    public void setMBeanServer(final MBeanServer server) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setMBeanServer(server);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerInvocationHandlerWrapper.this.proxy.setMBeanServer(server);
                return null;
            }
        });
    }
}

