/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.ModuleRegistry;
import org.jboss.classpool.plugins.jbosscl.DomainRegistry;
import org.jboss.classpool.plugins.jbosscl.JBossClRegistryHandler;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterModuleCallback
implements ModuleRegistry {
    Logger logger = Logger.getLogger(this.getClass());
    private Set<Module> registeredModules = new HashSet<Module>();
    private Set<Module> unregisteredModules = new HashSet<Module>();
    private DomainRegistry domainRegistry;

    public RegisterModuleCallback(DomainRegistry domainRegistry) {
        this.domainRegistry = domainRegistry;
    }

    public synchronized void addModule(Module module) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Adding module " + module));
        }
        this.unregisteredModules.add(module);
    }

    public synchronized void removeModule(Module module) {
        ClassLoader classLoader = this.domainRegistry.getClassLoader(module);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Removing module " + module + " and class loader " + classLoader));
        }
        JBossClRegistryHandler.getInstance().unregisterClassLoader(classLoader, module);
        this.domainRegistry.cleanupModule(module);
        this.registeredModules.remove(module);
        this.unregisteredModules.remove(module);
    }

    public synchronized void registerModule(Module module) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Registering module " + module));
        }
        this.registeredModules.add(module);
        this.unregisteredModules.remove(module);
        this.domainRegistry.initMapsForModule(module);
    }

    public synchronized Collection<Module> getUnregisteredModules() {
        return new ArrayList<Module>(this.unregisteredModules);
    }
}

