/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootPluginClassLoader
extends URLClassLoader {
    private final Log log = LogFactory.getLog(RootPluginClassLoader.class);
    private final Pattern classesToHideRegex;

    public RootPluginClassLoader(URL[] urls, ClassLoader parent, String ... classesToHideRegexStr) {
        super(urls, parent);
        Pattern pattern;
        if (classesToHideRegexStr != null && classesToHideRegexStr.length > 0) {
            StringBuilder fullPattern = new StringBuilder();
            for (String regex : classesToHideRegexStr) {
                if (fullPattern.length() > 0) {
                    fullPattern.append('|');
                }
                fullPattern.append('(').append(regex).append(')');
            }
            pattern = Pattern.compile(fullPattern.toString());
        } else {
            pattern = null;
        }
        this.classesToHideRegex = pattern;
        this.log.debug((Object)("Root plugin classloader: regex=[" + this.classesToHideRegex + "], urls=" + Arrays.asList(urls)));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            if (this.classesToHideRegex == null || !this.classesToHideRegex.matcher(name).matches()) {
                try {
                    clazz = super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Root plugin classloader cannot find unhidden class: " + name));
                    }
                    throw cnfe;
                }
            }
            try {
                clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Root plugin classloader cannot find potentially hidden class: " + name));
                }
                throw cnfe;
            }
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL res;
        if (this.classesToHideRegex == null) {
            res = super.getResource(name);
        } else {
            res = this.findResource(name);
            if (res == null) {
                res = super.getResource(name);
            }
        }
        return res;
    }
}

