/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.ClassLoaderManager;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginComponentFactory
implements ContainerService {
    private static final Log log = LogFactory.getLog(PluginComponentFactory.class);
    private PluginContainerConfiguration configuration;
    private InventoryManager inventoryManager;
    private PluginManager pluginManager;

    public ResourceDiscoveryComponent getDiscoveryComponent(ResourceType resourceType, ResourceContainer parentResourceContainer) throws PluginContainerException {
        ClassLoader classLoader;
        if (resourceType.equals((Object)PluginMetadataManager.TEST_PLATFORM_TYPE)) {
            return null;
        }
        PluginManager pluginMgr = this.getPluginManager();
        String className = pluginMgr.getMetadataManager().getDiscoveryClass(resourceType);
        String typeName = resourceType.getName();
        String pluginName = resourceType.getPlugin();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating discovery component [" + className + "] for resource type [" + typeName + ']'));
        }
        ClassLoaderManager classLoaderMgr = this.pluginManager.getClassLoaderManager();
        if (parentResourceContainer == null || this.getInventoryManager().getPlatform().equals((Object)parentResourceContainer.getResource())) {
            classLoader = classLoaderMgr.obtainPluginClassLoader(pluginName);
        } else {
            ClassLoader parentClassLoader = parentResourceContainer.getResourceClassLoader();
            classLoader = pluginName.equals(parentResourceContainer.getResource().getResourceType().getPlugin()) ? parentClassLoader : classLoaderMgr.obtainDiscoveryClassLoader(pluginName, parentClassLoader);
        }
        ResourceDiscoveryComponent discoveryComponent = (ResourceDiscoveryComponent)this.instantiateClass(classLoader, className);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created discovery component [" + className + "] for resource type [" + typeName + ']'));
        }
        return discoveryComponent;
    }

    public ResourceComponent buildResourceComponent(Resource resource) throws PluginContainerException {
        ResourceType resourceType = resource.getResourceType();
        String className = this.getPluginManager().getMetadataManager().getComponentClass(resourceType);
        ClassLoader resourceClassloader = this.getResourceClassloader(resource);
        ResourceComponent component = (ResourceComponent)this.instantiateClass(resourceClassloader, className);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created resource component [" + className + "] of resource type [" + resourceType + ']'));
        }
        return component;
    }

    public ClassLoader getResourceClassloader(Resource resource) throws PluginContainerException {
        try {
            ResourceContainer parentContainer;
            InventoryManager inventoryMgr = this.getInventoryManager();
            PluginManager pluginMgr = this.getPluginManager();
            ClassLoaderManager classLoaderMgr = pluginMgr.getClassLoaderManager();
            ResourceType resourceType = resource.getResourceType();
            if (resourceType.equals((Object)PluginMetadataManager.TEST_PLATFORM_TYPE)) {
                return Thread.currentThread().getContextClassLoader();
            }
            Resource parentResource = resource.getParentResource();
            if (parentResource != null) {
                parentContainer = inventoryMgr.getResourceContainer(parentResource);
                if (parentContainer == null) {
                    throw new PluginContainerException("Missing parent resource container for parent resource=" + parentResource);
                }
            } else {
                if (resource.equals((Object)inventoryMgr.getPlatform())) {
                    return classLoaderMgr.obtainPluginClassLoader(resourceType.getPlugin());
                }
                throw new PluginContainerException("Missing parent resource for resource=" + resource);
            }
            List<URL> additionalJars = this.askDiscoveryComponentForAdditionalClasspathUrls(resource, parentContainer);
            ClassLoader cl = classLoaderMgr.obtainResourceClassLoader(resource, parentContainer, additionalJars);
            return cl;
        }
        catch (Throwable t) {
            throw new PluginContainerException("Failed to obtain classloader for resource: " + resource, t);
        }
    }

    private List<URL> askDiscoveryComponentForAdditionalClasspathUrls(Resource resource, ResourceContainer parentContainer) throws Throwable {
        List<URL> additionalJars = null;
        ResourceDiscoveryComponent discoveryComponent = this.getDiscoveryComponent(resource.getResourceType(), parentContainer);
        if (discoveryComponent != null && discoveryComponent instanceof ClassLoaderFacet) {
            InventoryManager inventoryMgr = this.getInventoryManager();
            additionalJars = inventoryMgr.invokeDiscoveryComponentClassLoaderFacet(resource, discoveryComponent, parentContainer);
        }
        return additionalJars;
    }

    private Object instantiateClass(ClassLoader loader, String className) throws PluginContainerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading class [" + className + "] via classloader [" + loader + ']'));
        }
        if (loader == null) {
            throw new PluginContainerException("Cannot load class [" + className + "] with null classloader");
        }
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded class [" + clazz + "] from classloader [" + loader + ']'));
            }
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginContainerException("Could not instantiate plugin class [" + className + "] from classloader [" + loader + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginContainerException("Could not access plugin class [" + className + "] from classloader [" + loader + "]", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginContainerException("Could not find plugin class [" + className + "] from classloader [" + loader + "]", (Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new PluginContainerException("Plugin class was 'null' using loader [" + loader + "]", (Throwable)npe);
        }
    }

    private InventoryManager getInventoryManager() {
        if (this.inventoryManager == null) {
            this.inventoryManager = PluginContainer.getInstance().getInventoryManager();
        }
        return this.inventoryManager;
    }

    private PluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = PluginContainer.getInstance().getPluginManager();
        }
        return this.pluginManager;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutdown() {
        this.inventoryManager = null;
        this.pluginManager = null;
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }
}

