/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.modcluster.mcmp.MCMPServerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterServiceDRMEntry
implements Serializable,
Comparable<ModClusterServiceDRMEntry> {
    private static final long serialVersionUID = 8275232749243297786L;
    private final ClusterNode peer;
    private volatile Set<MCMPServerState> mcmpServerStates;
    private final Integer healthyEstablishedCount;
    private final Integer establishedCount;
    private final Integer healthyCount;
    private final Integer knownCount;
    private final Set<String> jvmRoutes;

    public ModClusterServiceDRMEntry(ClusterNode peer, Set<MCMPServerState> mcmpServerStates) {
        this(peer, mcmpServerStates, new HashSet<String>());
    }

    public ModClusterServiceDRMEntry(ClusterNode peer, Set<MCMPServerState> mcmpServerStates, Set<String> jvmRoutes) {
        assert (peer != null) : "peer is null";
        assert (jvmRoutes != null) : "jvmRoutes is null";
        this.peer = peer;
        this.mcmpServerStates = mcmpServerStates;
        int healthyEstablished = 0;
        int knownEstablished = 0;
        int healthy = 0;
        int known = 0;
        if (this.mcmpServerStates != null) {
            for (MCMPServerState state : this.mcmpServerStates) {
                ++known;
                if (state.getState() == MCMPServerState.State.OK) {
                    ++healthy;
                    if (!state.isEstablished()) continue;
                    ++knownEstablished;
                    ++healthyEstablished;
                    continue;
                }
                if (!state.isEstablished()) continue;
                ++knownEstablished;
            }
        }
        this.establishedCount = knownEstablished;
        this.healthyCount = healthy;
        this.healthyEstablishedCount = healthyEstablished;
        this.knownCount = known;
        this.jvmRoutes = jvmRoutes;
    }

    public ClusterNode getPeer() {
        return this.peer;
    }

    public Set<MCMPServerState> getMCMPServerStates() {
        return this.mcmpServerStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getJvmRoutes() {
        Set<String> set = this.jvmRoutes;
        synchronized (set) {
            return new HashSet<String>(this.jvmRoutes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJvmRoute(String jvmRoute) {
        Set<String> set = this.jvmRoutes;
        synchronized (set) {
            this.jvmRoutes.add(jvmRoute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJvmRoute(String jvmRoute) {
        Set<String> set = this.jvmRoutes;
        synchronized (set) {
            this.jvmRoutes.remove(jvmRoute);
        }
    }

    @Override
    public int compareTo(ModClusterServiceDRMEntry other) {
        int result = other.healthyEstablishedCount.compareTo(this.healthyEstablishedCount);
        if (result == 0 && (result = other.establishedCount.compareTo(this.establishedCount)) == 0 && (result = other.healthyCount.compareTo(this.healthyCount)) == 0) {
            result = other.knownCount.compareTo(this.knownCount);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ModClusterServiceDRMEntry)) {
            return false;
        }
        ModClusterServiceDRMEntry entry = (ModClusterServiceDRMEntry)object;
        return this.peer.equals(entry.peer);
    }

    public int hashCode() {
        return this.peer.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("{peer=").append(this.peer);
        if (this.mcmpServerStates != null) {
            builder.append(",states=").append(this.mcmpServerStates);
        }
        return builder.append("}").toString();
    }
}

