/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.metadata;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.SslTcpConnector;
import org.jboss.xnio.SslTcpServer;
import org.jboss.xnio.TcpAcceptor;
import org.jboss.xnio.TcpChannelSource;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.TcpServer;
import org.jboss.xnio.UdpServer;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.helpers.BindingService;
import org.jboss.xnio.helpers.ChannelListenerService;
import org.jboss.xnio.helpers.ProviderFactory;
import org.jboss.xnio.metadata.BindingMetaData;
import org.jboss.xnio.metadata.ChannelListenerMetaData;
import org.jboss.xnio.metadata.ManagedBindingMetaData;
import org.jboss.xnio.metadata.OptionMetaData;
import org.jboss.xnio.metadata.OptionedMetaData;
import org.jboss.xnio.metadata.OptionsOnlyMetaData;
import org.jboss.xnio.metadata.PipeConnectorMetaData;
import org.jboss.xnio.metadata.ProviderMetaData;
import org.jboss.xnio.metadata.RefMetaData;
import org.jboss.xnio.metadata.SocketAddressMetaData;
import org.jboss.xnio.metadata.SslTcpConnectorMetaData;
import org.jboss.xnio.metadata.SslTcpServerMetaData;
import org.jboss.xnio.metadata.TcpAcceptorMetaData;
import org.jboss.xnio.metadata.TcpChannelSourceMetaData;
import org.jboss.xnio.metadata.TcpConnectorMetaData;
import org.jboss.xnio.metadata.TcpServerMetaData;
import org.jboss.xnio.metadata.UdpServerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XnioMetaDataHelper {
    static final String DEFAULT_PROVIDER_BEAN_NAME = "XnioProvider";
    private static final AtomicInteger PRIVATE_SEQ = new AtomicInteger(new Random().nextInt());

    private XnioMetaDataHelper() {
    }

    private static Option getOption(OptionMetaData omd) {
        String className = omd.getClassName();
        String name = omd.getName();
        return Option.fromString((String)(className == null ? Options.class.getName() + "." + name : className + "." + name), (ClassLoader)Options.class.getClassLoader());
    }

    private static <T> void setOption(OptionMap.Builder builder, Option<T> option, String value) {
        builder.set(option, option.parseValue(value));
    }

    private static OptionMap getOptionMap(OptionedMetaData o) {
        List<OptionMetaData> options;
        OptionMap.Builder builder = OptionMap.builder();
        OptionMetaData firstOption = o.getOption();
        if (firstOption != null) {
            Option option = XnioMetaDataHelper.getOption(firstOption);
            XnioMetaDataHelper.setOption(builder, option, firstOption.getValue());
        }
        if ((options = o.getOptions()) != null) {
            for (OptionMetaData omd : options) {
                Option option = XnioMetaDataHelper.getOption(omd);
                XnioMetaDataHelper.setOption(builder, option, omd.getValue());
            }
        }
        return builder.getMap();
    }

    public static void add(List<BeanMetaData> list, ChannelListenerMetaData metaData) {
        ChannelListenerMetaData.Type type = metaData.getType();
        String listenerName = metaData.getListener().getName();
        String forBean = metaData.getForBean();
        RefMetaData executor = metaData.getExecutor();
        XnioMetaDataHelper.addListener(list, type, listenerName, forBean, executor);
    }

    private static void addListener(List<BeanMetaData> list, ChannelListenerMetaData.Type type, String listenerName, String forBean, RefMetaData executor) {
        String property;
        String name = "XNIO:Listener:" + type.toString() + ":" + forBean;
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)ChannelListenerService.class.getName());
        builder.ignoreCreate();
        builder.ignoreDestroy();
        builder.setStart("start");
        builder.setStop("stop");
        switch (type) {
            case ACCEPT: {
                property = "openSetter";
                break;
            }
            case BIND: {
                property = "bindSetter";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builder.addConstructorParameter(ChannelListener.class.getName(), builder.createInject((Object)listenerName));
        builder.addConstructorParameter(ChannelListener.Setter.class.getName(), builder.createInject((Object)forBean, property));
        builder.addConstructorParameter(Executor.class.getName(), executor == null ? builder.createNull() : builder.createInject((Object)executor.getName()));
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, PipeConnectorMetaData metaData, String methodName) {
        RefMetaData openListener;
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)metaData.getName(), (String)ChannelSource.class.getName());
        builder.ignoreCreate();
        builder.ignoreDestroy();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod(methodName);
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        if ((openListener = metaData.getOpenListener()) == null) {
            builder.addConstructorParameter(ChannelListener.class.getName(), builder.createNull());
        } else {
            builder.addConstructorParameter(ChannelListener.class.getName(), builder.createInject((Object)openListener.getName()));
        }
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, TcpServerMetaData metaData) {
        RefMetaData bindListener;
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)TcpServer.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setDestroy("close");
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod("createTcpServer");
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        builder.addConstructorParameter(ChannelListener.class.getName(), builder.createNull());
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        RefMetaData acceptListener = metaData.getAcceptListener();
        if (acceptListener != null) {
            XnioMetaDataHelper.addListener(list, ChannelListenerMetaData.Type.ACCEPT, acceptListener.getName(), name, null);
        }
        if ((bindListener = metaData.getBindListener()) != null) {
            XnioMetaDataHelper.addListener(list, ChannelListenerMetaData.Type.BIND, bindListener.getName(), name, null);
        }
        AbstractArrayMetaData aamd = new AbstractArrayMetaData();
        aamd.setElementType(InetSocketAddress.class.getName());
        AbstractArrayMetaData values = aamd;
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, Collections.singletonList(metaData.getBinding()));
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, metaData.getBindings());
        XnioMetaDataHelper.addBindingValues((List<ValueMetaData>)values, metaData.getManagedBindings());
        XnioMetaDataHelper.addBindings(list, (List<ValueMetaData>)values, name);
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, SslTcpServerMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)SslTcpServer.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setDestroy("close");
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod("createSslTcpServer");
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        builder.addConstructorParameter(ChannelListener.class.getName(), builder.createNull());
        RefMetaData acceptListener = metaData.getAcceptListener();
        if (acceptListener != null) {
            XnioMetaDataHelper.addListener(list, ChannelListenerMetaData.Type.ACCEPT, acceptListener.getName(), name, null);
        }
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        RefMetaData bindListener = metaData.getBindListener();
        if (bindListener != null) {
            builder.addPropertyMetaData("getBindSetter.set", builder.createInject((Object)bindListener.getName()));
        }
        AbstractArrayMetaData aamd = new AbstractArrayMetaData();
        aamd.setElementType(InetSocketAddress.class.getName());
        AbstractArrayMetaData values = aamd;
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, Collections.singletonList(metaData.getBinding()));
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, metaData.getBindings());
        XnioMetaDataHelper.addBindingValues((List<ValueMetaData>)values, metaData.getManagedBindings());
        XnioMetaDataHelper.addBindings(list, (List<ValueMetaData>)values, name);
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, TcpConnectorMetaData metaData) {
        SocketAddressMetaData binding;
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)metaData.getName(), (String)TcpConnector.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod("createTcpConnector");
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        if ((binding = metaData.getBinding()) != null) {
            builder.addConstructorParameter(InetSocketAddress.class.getName(), (Object)binding.getSocketAddress());
        }
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, SslTcpConnectorMetaData metaData) {
        SocketAddressMetaData binding;
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)metaData.getName(), (String)SslTcpConnector.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod("createSslTcpConnector");
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        if ((binding = metaData.getBinding()) != null) {
            builder.addConstructorParameter(InetSocketAddress.class.getName(), (Object)binding.getSocketAddress());
        }
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, TcpChannelSourceMetaData metaData) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)metaData.getName(), (String)TcpChannelSource.class.getName());
        builder.ignoreCreate();
        builder.ignoreDestroy();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setFactory(builder.createInject((Object)metaData.getTcpConnector()));
        builder.addConstructorParameter(InetSocketAddress.class.getName(), (Object)metaData.getDestination().getSocketAddress());
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, TcpAcceptorMetaData metaData) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)metaData.getName(), (String)TcpAcceptor.class.getName());
        builder.ignoreCreate();
        builder.ignoreDestroy();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod("createTcpAcceptor");
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, UdpServerMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)UdpServer.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setDestroy("close");
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod("createUdpServer");
        RefMetaData executor = metaData.getExecutor();
        if (executor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)executor.getName()));
        }
        RefMetaData bindListener = metaData.getBindListener();
        builder.addConstructorParameter(ChannelListener.class.getName(), bindListener == null ? builder.createNull() : builder.createInject((Object)bindListener.getName()));
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        AbstractArrayMetaData aamd = new AbstractArrayMetaData();
        aamd.setElementType(InetSocketAddress.class.getName());
        AbstractArrayMetaData values = aamd;
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, Collections.singletonList(metaData.getBinding()));
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, metaData.getBindings());
        XnioMetaDataHelper.addBindingValues((List<ValueMetaData>)values, metaData.getManagedBindings());
        XnioMetaDataHelper.addBindings(list, (List<ValueMetaData>)values, name);
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, OptionsOnlyMetaData metaData, String methodName, Class<?> clazz) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)metaData.getName(), (String)clazz.getName());
        builder.ignoreCreate();
        builder.ignoreDestroy();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setFactory(builder.createInject((Object)provider));
        builder.setFactoryMethod(methodName);
        builder.addConstructorParameter(OptionMap.class.getName(), (Object)XnioMetaDataHelper.getOptionMap(metaData));
        list.add(builder.getBeanMetaData());
    }

    public static void add(List<BeanMetaData> list, String provider, ChannelListenerMetaData metaData) {
        XnioMetaDataHelper.addListener(list, metaData.getType(), metaData.getListener().getName(), metaData.getForBean(), metaData.getExecutor());
    }

    public static void add(List<BeanMetaData> list, String provider, BindingMetaData metaData) {
        List<SocketAddressMetaData> bindings = metaData.getBindings();
        String serverName = metaData.getForName();
        AbstractArrayMetaData aamd = new AbstractArrayMetaData();
        aamd.setElementType(InetSocketAddress.class.getName());
        AbstractArrayMetaData values = aamd;
        XnioMetaDataHelper.addSocketAddressValues((List<ValueMetaData>)values, bindings);
        XnioMetaDataHelper.addBindings(list, (List<ValueMetaData>)values, serverName);
    }

    public static void add(List<BeanMetaData> list, String provider, ProviderMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Xnio.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.setDestroy("close");
        builder.setFactoryClass(ProviderFactory.class.getName());
        builder.setFactoryMethod("create");
        builder.addConstructorParameter(String.class.getName(), builder.createValue((Object)name));
        String providerName = metaData.getImplementationName();
        builder.addConstructorParameter(String.class.getName(), providerName == null ? builder.createNull() : builder.createInject((Object)providerName));
        builder.addConstructorParameter(MBeanServer.class.getName(), builder.createInject((Object)"JMXKernel", "mbeanServer"));
        RefMetaData threadFactory = metaData.getThreadFactory();
        builder.addConstructorParameter(ThreadFactory.class.getName(), threadFactory == null ? builder.createNull() : builder.createInject((Object)threadFactory.getName()));
        RefMetaData executor = metaData.getExecutor();
        builder.addConstructorParameter(Executor.class.getName(), executor == null ? builder.createNull() : builder.createInject((Object)executor.getName()));
        builder.addConstructorParameter(OptionMap.class.getName(), builder.createValue((Object)XnioMetaDataHelper.getOptionMap(metaData)));
        list.add(builder.getBeanMetaData());
    }

    private static void addSocketAddressValues(List<ValueMetaData> values, List<SocketAddressMetaData> addresses) {
        for (SocketAddressMetaData address : addresses) {
            if (address == null) continue;
            values.add((ValueMetaData)new AbstractValueMetaData((Object)address.getSocketAddress()));
        }
    }

    private static void addBindingValues(List<ValueMetaData> values, List<ManagedBindingMetaData> bindings) {
        for (ManagedBindingMetaData binding : bindings) {
            SocketAddressMetaData defaultBinding = binding.getDefaultBindAddress();
            String service = binding.getService();
            String bindingName = binding.getBinding();
            AbstractValueFactoryMetaData value = new AbstractValueFactoryMetaData((Object)"ServiceBindingManager", "getInetSocketAddressBinding");
            ArrayList<AbstractParameterMetaData> parameters = new ArrayList<AbstractParameterMetaData>();
            parameters.add(new AbstractParameterMetaData(String.class.getName(), (ValueMetaData)new AbstractValueMetaData((Object)service)));
            parameters.add(new AbstractParameterMetaData(String.class.getName(), (ValueMetaData)new AbstractValueMetaData((Object)bindingName)));
            if (defaultBinding != null) {
                parameters.add(new AbstractParameterMetaData(String.class.getName(), defaultBinding.getAddress()));
                parameters.add(new AbstractParameterMetaData(Integer.TYPE.getName(), (Object)defaultBinding.getPort()));
            }
            value.setParameters(parameters);
            values.add((ValueMetaData)value);
        }
    }

    private static void addBindings(List<BeanMetaData> list, List<ValueMetaData> bindings, String serverName) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)XnioMetaDataHelper.generateBindingName(serverName), (String)BindingService.class.getName());
        builder.ignoreCreate();
        builder.setStart("start");
        builder.setStop("stop");
        builder.ignoreDestroy();
        builder.addPropertyMetaData("addresses", (ValueMetaData)bindings);
        builder.addPropertyMetaData("server", builder.createInject((Object)serverName));
        list.add(builder.getBeanMetaData());
    }

    private static String generateBindingName(String forBean) {
        return "XNIO:Binding:" + PRIVATE_SEQ.getAndIncrement() + ":" + forBean;
    }
}

