/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.deployer.MultipleJBossXBDeployer;
import org.jboss.vfs.VFSInputSource;
import org.jboss.vfs.VirtualFile;
import org.jboss.xb.util.JBossXBHelper;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleSchemaResolverDeployer<T>
extends MultipleJBossXBDeployer<T> {
    private Set<Class<?>> excluded;
    private Set<String> namespaces;

    public MultipleSchemaResolverDeployer(Class<T> output, Map<String, Class<?>> mappings) {
        this(output, mappings, null);
    }

    public MultipleSchemaResolverDeployer(Class<T> output, Map<String, Class<?>> mappings, Set<Class<?>> excluded) {
        this(output, mappings, null, null, excluded);
    }

    public MultipleSchemaResolverDeployer(Class<T> output, Map<String, Class<?>> mappings, String suffix, Class<?> suffixClass, Set<Class<?>> excluded) {
        super(output, mappings, suffix, suffixClass);
        if (excluded == null) {
            excluded = Collections.emptySet();
        }
        this.excluded = excluded;
        this.namespaces = new HashSet<String>();
    }

    public void create() {
        for (Class<?> metadata : this.getMappings().values()) {
            this.registerMetaDataClass(metadata);
        }
        if (this.getSuffixClass() != null) {
            this.registerMetaDataClass(this.getSuffixClass());
        }
    }

    protected void registerMetaDataClass(Class<?> metadata) {
        if (!this.excluded.contains(metadata)) {
            String namespace = JBossXBHelper.findNamespace(metadata);
            if (namespace == null || "##default".equals(namespace)) {
                throw new IllegalArgumentException("Registering schema with JBossXB is enabled, but cannot find namespace on class or package: " + metadata + ", perhaps missing @JBossXmlSchema or using default namespace attribute.");
            }
            JBossXBHelper.addClassBinding((String)namespace, metadata);
            this.namespaces.add(namespace);
        }
    }

    public void destroy() {
        for (String namespace : this.namespaces) {
            JBossXBHelper.removeClassBinding((String)namespace);
        }
        this.namespaces.clear();
    }

    @Override
    protected <U> U parse(Class<U> expectedType, VirtualFile file, Object root) throws Exception {
        VFSInputSource source = new VFSInputSource(file);
        return (U)this.getHelper().parse(expectedType, (InputSource)source);
    }
}

