/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.SecurityActions;

public class ConfigurationBuilder {
    private static final Logger log = Logger.getLogger(ConfigurationBuilder.class.getName());
    private static final String EXTENSION_LOADER_IMPL = "org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader";
    private ExtensionLoader extensionLoader;
    private ExecutorService executorService;

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder extensionLoader(ExtensionLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
        return this;
    }

    public ConfigurationBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Configuration build() {
        this.setDefaults();
        return new Configuration(this);
    }

    private void setDefaults() {
        if (this.getExtensionLoader() == null) {
            ExtensionLoader loader = this.createDefaultExtensionLoader();
            if (log.isLoggable(Level.FINER)) {
                log.finer("User has not defined an explicit " + ExtensionLoader.class.getSimpleName() + "; defaulting to " + loader);
            }
            this.extensionLoader(loader);
        }
    }

    ExtensionLoader createDefaultExtensionLoader() {
        return SecurityActions.newInstance(EXTENSION_LOADER_IMPL, new Class[0], new Object[0], ExtensionLoader.class);
    }
}

