/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Iterator;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.DeclareDef;

public class DeclareChecker {
    public static void checkDeclares(AspectManager manager, CtClass clazz, ClassAdvisor advisor) {
        Iterator<DeclareDef> it = manager.getDeclares();
        while (it.hasNext()) {
            DeclareDef declare = it.next();
            if (!declare.matches((Advisor)advisor, clazz)) continue;
            StringBuffer sb = new StringBuffer(" condition\n\t'" + declare.getExpr() + "'\nwas broken for class " + clazz.getName() + "\n\t" + declare.getMsg() + "\n");
            if (declare.getWarning()) {
                sb.insert(0, "WARNING: declare-warning");
                System.out.println(sb.toString());
                continue;
            }
            sb.insert(0, "ERROR: declare-error");
            throw new RuntimeException(sb.toString());
        }
    }

    public static void checkDeclares(AspectManager manager, NewExpr call, ClassAdvisor advisor) throws NotFoundException {
        DeclareChecker.checkDeclares(manager, call, null, advisor);
    }

    public static void checkDeclares(AspectManager manager, MethodCall call, ClassAdvisor advisor) throws NotFoundException {
        DeclareChecker.checkDeclares(manager, null, call, advisor);
    }

    private static void checkDeclares(AspectManager manager, NewExpr newcall, MethodCall mcall, ClassAdvisor advisor) throws NotFoundException {
        Iterator<DeclareDef> it = manager.getDeclares();
        while (it.hasNext()) {
            CtMethod met;
            CtConstructor con;
            CtBehavior caller;
            DeclareDef declare = it.next();
            StringBuffer sb = new StringBuffer(" condition\n\t'" + declare.getExpr() + "'\nwas broken for ");
            if ((newcall == null || !declare.matchesCall((Advisor)advisor, newcall)) && (mcall == null || !declare.matchesCall((Advisor)advisor, mcall))) continue;
            if (mcall != null) {
                sb.append("method call:");
                caller = mcall.where();
                if (caller instanceof CtConstructor) {
                    con = (CtConstructor)caller;
                    DeclareChecker.addConstructor(sb, con);
                    sb.append(" calls ");
                    DeclareChecker.addMethod(sb, mcall.getMethod());
                } else if (caller instanceof CtMethod) {
                    met = (CtMethod)caller;
                    DeclareChecker.addMethod(sb, met);
                    sb.append(" calls ");
                    DeclareChecker.addMethod(sb, mcall.getMethod());
                }
            } else if (newcall != null) {
                sb.append("constructor call: ");
                caller = newcall.where();
                if (caller instanceof CtConstructor) {
                    con = (CtConstructor)caller;
                    DeclareChecker.addConstructor(sb, con);
                    sb.append(" calls ");
                    DeclareChecker.addConstructor(sb, newcall.getConstructor());
                } else if (caller instanceof CtMethod) {
                    met = (CtMethod)caller;
                    DeclareChecker.addMethod(sb, met);
                    sb.append(" calls ");
                    DeclareChecker.addConstructor(sb, newcall.getConstructor());
                }
            }
            sb.append("\n\t" + declare.getMsg() + "\n");
            if (declare.getWarning()) {
                sb.insert(0, "WARNING: declare-warning");
                System.out.println(sb.toString());
                continue;
            }
            sb.insert(0, "ERROR: declare-error");
            throw new RuntimeException(sb.toString());
        }
    }

    private static void addMethod(StringBuffer sb, CtMethod method) {
        sb.append(method.getDeclaringClass().getName() + "." + method.getName() + method.getSignature());
    }

    private static void addConstructor(StringBuffer sb, CtConstructor con) {
        sb.append(con.getDeclaringClass().getName() + ".new" + con.getSignature());
    }
}

