/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.usertx.client.ClientUserTransaction;
import org.jboss.tm.usertx.interfaces.UserTransactionSession;
import org.jboss.tm.usertx.interfaces.UserTransactionSessionFactory;
import org.jboss.tm.usertx.server.ClientUserTransactionServiceMBean;
import org.jboss.tm.usertx.server.UserTransactionSessionImpl;

public class ClientUserTransactionService
extends ServiceMBeanSupport
implements ClientUserTransactionServiceMBean {
    public static String JNDI_NAME = "UserTransaction";
    private Map marshalledInvocationMapping = new HashMap();
    private ObjectName txProxyName;
    private Object txProxy;

    public void setTxProxyName(ObjectName proxyName) {
        this.txProxyName = proxyName;
    }

    public Object invoke(Invocation invocation) throws Exception {
        if (invocation instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            mi.setMethodMap(this.marshalledInvocationMapping);
        }
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Object value = null;
        try {
            if (UserTransactionSessionFactory.class.isAssignableFrom(method.getDeclaringClass())) {
                value = this.txProxy;
            } else if (method.getName().equals("begin")) {
                Integer timeout = (Integer)args[0];
                UserTransactionSession session = UserTransactionSessionImpl.getInstance();
                value = session.begin(timeout);
            } else if (!method.getName().equals("destroy")) {
                UserTransactionSession session = UserTransactionSessionImpl.getInstance();
                value = method.invoke((Object)session, args);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t, method.toString());
        }
        return value;
    }

    protected void startService() throws Exception {
        Long hash;
        Method method;
        int m;
        InitialContext ctx = new InitialContext();
        ctx.bind(JNDI_NAME, (Object)ClientUserTransaction.getSingleton());
        this.txProxy = this.getServer().getAttribute(this.txProxyName, "Proxy");
        HashMap<Long, Method> tmpMap = new HashMap<Long, Method>(13);
        Method[] methods = UserTransactionSession.class.getMethods();
        for (m = 0; m < methods.length; ++m) {
            method = methods[m];
            hash = new Long(MarshalledInvocation.calculateHash(method));
            tmpMap.put(hash, method);
        }
        methods = UserTransactionSessionFactory.class.getMethods();
        for (m = 0; m < methods.length; ++m) {
            method = methods[m];
            hash = new Long(MarshalledInvocation.calculateHash(method));
            tmpMap.put(hash, method);
        }
        this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
        Registry.bind((Object)new Integer(this.serviceName.hashCode()), (Object)this.serviceName);
    }

    protected void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(JNDI_NAME);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to unbind " + JNDI_NAME), (Throwable)e);
        }
        Registry.unbind((Object)new Integer(this.serviceName.hashCode()));
    }
}

